-----------------------------------
-- Spell: Orcish Counterstance
-- Increases the caster's chance of countering.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("orcish_counterstance")
local path = "xi.actions.spells.blue.orcish_counterstance"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local power = 50
    local duration = xi.spells.blue.calculateDurationWithDiffusion(caster, 180)

    if not target:addStatusEffect(xi.effect.COUNTERSTANCE, power, 0, duration) then
        spell:setMsg(xi.msg.basic.COUNTERSTANCE)
    end

    return xi.effect.COUNTERSTANCE
end)

return m
