-----------------------------------
-- Spell: Magic Barrier
-- Grants a Magic Shield effect.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("magic_barrier")
local path = "xi.actions.spells.blue.magic_barrier"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local power = 0 -- 50%  DMGMAGIC
    local duration = xi.spells.blue.calculateDurationWithDiffusion(caster, 300)

    if not target:addStatusEffect(xi.effect.MAGIC_SHIELD, power, 0, duration) then
        spell:setMsg(xi.msg.basic.MAGIC_SHIELD)
    end

    target:getStatusEffect(xi.effect.MAGIC_SHIELD):setSubPower(1)

    return xi.effect.MAGIC_SHIELD
end)

return m
