-----------------------------------
-- Spell: Heavy Strike
-- Damage varies with TP.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("heavy_strike")
local path = "xi.actions.spells.blue.heavy_strike"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.ARCANA
    params.bonusacc = -100.0
    params.critchance = 100.0
    params.tpmod = xi.spells.blue.tpMod.DAMAGE
    params.attackType = xi.attackType.PHYSICAL
    params.damageType = xi.damageType.BLUNT
    params.scattr = xi.skillchainType.FRAGMENTATION
    params.scattr2 = xi.skillchainType.TRANSFIXION
    params.numhits = 1
    params.multiplier = 4.0
    params.tp150 = 5.0
    params.tp300 = 6.0
    params.azuretp = 2.0
    params.duppercap = 69
    params.str_wsc = 0.5
    params.dex_wsc = 0.0
    params.vit_wsc = 0.0
    params.agi_wsc = 0.0
    params.int_wsc = 0.0
    params.mnd_wsc = 0.0
    params.chr_wsc = 0.0

    local damage = xi.spells.blue.usePhysicalSpell(caster, target, spell, params)

    return damage
end)

return m
