-----------------------------------
-- Spell: Harden Shell
-- Enhances defense.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("harden_shell")
local path = "xi.actions.spells.blue.harden_shell"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local power = 100
    local duration = xi.spells.blue.calculateDurationWithDiffusion(caster, 90)

    if not target:addStatusEffect(xi.effect.DEFENSE_BOOST, power, 0, duration) then
        spell:setMsg(xi.msg.basic.DEFENSE_BOOST)
    end

    return xi.effect.DEFENSE_BOOST
end)

return m
