-----------------------------------
-- Glutinous Dart
-- Damage Varies With TP.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("glutinous_dart_blu")
local path = "xi.actions.spells.blue.glutinous_dart"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.BEASTMEN
    params.tpmod = xi.spells.blue.tpMod.DAMAGE
    params.attackType = xi.attackType.PHYSICAL
    params.damageType = xi.damageType.PIERCING
    params.scattr = xi.skillchainType.FRAGMENTATION
    params.numhits = 1
    params.multiplier = 4.0
    params.tp150 = 1.0
    params.tp300 = 2.0
    params.azuretp = 2.5
    params.duppercap = 80
    params.str_wsc = 0.5
    params.dex_wsc = 0.0
    params.vit_wsc = 0.5
    params.agi_wsc = 0.0
    params.int_wsc = 0.0
    params.mnd_wsc = 0.0
    params.chr_wsc = 0.0

    local damage = xi.spells.blue.usePhysicalSpell(caster, target, spell, params)

    return damage
end)

return m
