-----------------------------------
-- Spell: Empty Thrash
-- Delivers an area attack. Accuracy varies with TP.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("empty_thrash")
local path = "xi.actions.spells.blue.empty_thrash"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.EMPTY
    params.tpmod = xi.spells.blue.tpMod.ACC
    params.bonusacc = 0
    if caster:hasStatusEffect(xi.effect.AZURE_LORE) then
        params.bonusacc = 70
    elseif caster:hasStatusEffect(xi.effect.CHAIN_AFFINITY) then
        params.bonusacc = math.floor(caster:getTP() / 50)
    end
    params.attackType = xi.attackType.PHYSICAL
    params.damageType = xi.damageType.SLASHING
    params.scattr = xi.skillchainType.COMPRESSION
    params.scattr2 = xi.skillchainType.SCISSION
    params.numhits = 1
    params.multiplier = 4.0
    params.tp150 = 2.0
    params.tp300 = 2.0
    params.azuretp = 2.0
    params.duppercap = 69
    params.str_wsc = 0.5
    params.dex_wsc = 0.0
    params.vit_wsc = 0.0
    params.agi_wsc = 0.0
    params.int_wsc = 0.0
    params.mnd_wsc = 0.0
    params.chr_wsc = 0.0

    local damage = xi.spells.blue.usePhysicalSpell(caster, target, spell, params)

    return damage
end)

return m
