-----------------------------------
-- Spell: Demoralizing Roar
-- Weakens the attack of enemies within range.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("demoralizing_roar")
local path = "xi.actions.spells.blue.demoralizing_roar"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.LIZARD
    params.effect = xi.effect.ATTACK_DOWN
    local power = 20
    local tick = 3
    local duration = 30
    local resistThreshold = 0.5
    local isGaze = false
    local isConal = false

    return xi.spells.blue.useEnfeeblingSpell(caster, target, spell, params, power, tick, duration, resistThreshold, isGaze, isConal)
end)

return m
