-----------------------------------
-- Spell: Carcharian Verve
-- Enhances attack and magic attack. Reduces spell interruption rate.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("carcharian_verve")
local path = "xi.actions.spells.blue.carcharian_verve"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local durationOne = xi.spells.blue.calculateDurationWithDiffusion(caster, 60)
    local durationTwo = xi.spells.blue.calculateDurationWithDiffusion(caster, 900)

    target:addStatusEffect(xi.effect.MAGIC_ATK_BOOST, 20, 0, durationOne)
    target:addStatusEffect(xi.effect.ATTACK_BOOST, 20, 0, durationOne)

    if not target:addStatusEffect(xi.effect.AQUAVEIL, 20, 0, durationTwo) then
        spell:setMsg(xi.msg.basic.AQUAVEIL)
    end
    
    return xi.effect.AQUAVEIL
end)

return m
