-----------------------------------
-- Spell: Blazing Bound
-- Deals fire damage to an enemy.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("blazing_bound")
local path = "xi.actions.spells.blue.blazing_bound"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.VORAGEAN
    params.attackType = xi.attackType.MAGICAL
    params.damageType = xi.damageType.FIRE
    params.attribute = xi.mod.INT
    params.multiplier = 6.0
    params.tMultiplier = 5.0
    params.duppercap = 80
    params.str_wsc = 0.3
    params.dex_wsc = 0.0
    params.vit_wsc = 0.0
    params.agi_wsc = 0.0
    params.int_wsc = 0.0
    params.mnd_wsc = 0.0
    params.chr_wsc = 0.0

    local damage =  xi.spells.blue.useMagicalSpell(caster, target, spell, params)

    return damage
end)

return m
