-----------------------------------
-- Spell: Barrier Tusk
-- Grants a Physical Shield effect
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("barrier_tusk")
local path = "xi.actions.spells.blue.barrier_tusk"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local power = 0 -- 50%  DMGPHYS
    local duration = xi.spells.blue.calculateDurationWithDiffusion(caster, 300)

    if not target:addStatusEffect(xi.effect.PHYSICAL_SHIELD, power, 0, duration) then
        spell:setMsg(xi.msg.basic.PHYSICAL_SHIELD)
    end

    return xi.effect.PHYSICAL_SHIELD
end)

return m
