-----------------------------------
-- Spell: Acrid Stream
-- Deals water damage to enemies within a fan-shaped area originating from the caster.
-- Additional effect: Lowers target's Magic Defense.
-----------------------------------
require("modules/module_utils")
-----------------------------------
local m = Module:new("acrid_stream")
local path = "xi.actions.spells.blue.acrid_stream"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMagicCastingCheck", function(mob, target, spell)
    return 0
end)

m:addOverride(path .. ".onSpellCast", function(caster, target, spell)
    local params = {}
    params.ecosystem = xi.ecosystem.VORAGEAN
    params.attackType = xi.attackType.MAGICAL
    params.damageType = xi.damageType.WATER
    params.attribute = xi.mod.INT
    params.multiplier = 3
    params.azureBonus = 0.5
    params.tMultiplier = 2.3
    params.tp150 = 3.5
    params.tp300 = 4.0
    params.azuretp = 4.3
    params.duppercap = 69
    params.str_wsc = 0.0
    params.dex_wsc = 0.0
    params.vit_wsc = 0.0
    params.agi_wsc = 0.0
    params.int_wsc = 0.0
    params.mnd_wsc = 0.3
    params.chr_wsc = 0.0
    local resistThreshold = 0.5
    local duration = 120

    local damage = xi.spells.blue.useMagicalSpell(caster, target, spell, params)

    params.attribute = xi.mod.INT
    params.skillType = xi.skill.BLUE_MAGIC
    local resist = applyResistanceEffect(caster, target, spell, params)

    if resist >= resistThreshold then
        target:addStatusEffect(xi.effect.MAGIC_DEF_DOWN, 10, 0, duration * resist)
    end

    return damage
end)

return m
