-----------------------------------
-- CatsEyeXI
-- Windurst mission 3-1 fix
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
-----------------------------------
local m = Module:new("windy_3_1_fix")

m:addOverride("xi.zones.Heavens_Tower.npcs._6q1.onTrigger", function(player, npc)
    local ID = zones[player:getZoneID()]
    if player:getNation() == 2 then
        if player:getCurrentMission(xi.mission.log_id.WINDURST) == xi.mission.id.windurst.TO_EACH_HIS_OWN_RIGHT and
            player:getMissionStatus(xi.mission.log_id.WINDURST) >= 1 and not
            player:hasKeyItem(xi.ki.STARWAY_STAIRWAY_BAUBLE)
        then
            npcUtil.giveKeyItem(player, xi.ki.STARWAY_STAIRWAY_BAUBLE)
            player:setMissionStatus(xi.mission.log_id.WINDURST, 1)
        elseif player:hasKeyItem(xi.ki.STARWAY_STAIRWAY_BAUBLE) then
            if player:getXPos() < -14 then
                player:startEvent(106)
            else
                player:startEvent(105)
            end
        else
            player:messageSpecial(ID.text.STAIRWAY_LOCKED)
        end
    else
        player:messageSpecial(ID.text.STAIRWAY_ONLY_CITIZENS)
    end

    return 1
end)

return m
