require("modules/module_utils")
require('scripts/globals/npc_util')
require('scripts/globals/quests')
require('scripts/globals/missions')
-----------------------------------
local m = Module:new("npc_synergy_furnace")

local synergyZones =
{
    'Bastok_Markets',
    'Bastok_Mines',
    'Port_Bastok',
    'Northern_San_dOria',
    'Upper_Jeuno',
    'Lower_Jeuno',
    'Port_Jeuno',
    'Tavnazian_Safehold',
    'Aht_Urhgan_Whitegate',
}

local resultType =
{
    NONE    = 0,
    REGULAR = 1,
    HIGH_Q  = 2,
    KIRIN   = 3,
    SPECIAL = 4
}

local recipes =
{
    [18632] = { 17545, 17551, 17559, 17555, 17553, 17549, 17547, 17557 }, -- Iridal Staff
    [18633] = { 17546, 17552, 17560, 17556, 17554, 17550, 17548, 17558 }, -- Chatoyant Staff
    [28419] = { 15435, 15436, 15437, 15438, 15439, 15440, 15441, 15442 }, -- Hachirin-no-Obi
    [27510] = { 15495, 15500, 15496, 15499, 15498, 15497, 15501, 15502 }, -- Fotia Gorget

    [xi.item.ARTISANS_TORQUE] =
    {
        10948, -- carvers_torque
        10949, -- smithys_torque
        10950, -- goldsmiths_torque
        10951, -- weavers_torque
        10952, -- tanners_torque
        10953, -- boneworkers_torque
        10954, -- alchemists_torque
        10955, -- culinarians_torque
    },

    [xi.item.ARTISANS_RING] =
    {
        15819, -- carpenters_ring
        15820, -- smiths_ring
        15821, -- goldsmiths_ring
        15822, -- tailors_ring
        15823, -- tanners_ring
        15824, -- bonecrafters_ring
        15825, -- alchemists_ring
        15826, -- chefs_ring
    },

    [xi.item.OMNI_GRIP] =
    {
        19031, -- fire_grip
        19032, -- water_grip
        19033, -- wind_grip
        19034, -- ice_grip
        19035, -- thunder_grip
        19036, -- earth_grip
        19037, -- light_grip
        19038, -- dark_grip
    },

    [xi.item.PRISMATIC_CLUSTER] =
    {
        { xi.item.FIRE_CLUSTER,      12 },
        { xi.item.ICE_CLUSTER,       12 },
        { xi.item.WIND_CLUSTER,      12 },
        { xi.item.EARTH_CLUSTER,     12 },
        { xi.item.LIGHTNING_CLUSTER, 12 },
        { xi.item.WATER_CLUSTER,     12 },
        { xi.item.LIGHT_CLUSTER,     12 },
        { xi.item.DARK_CLUSTER,      12 },
    },

    [xi.item.GOBLIN_BREW_P1] =
    {
        { xi.item.GOBLIN_BREW, 8 },
    },

    [xi.item.GOBLIN_BREW_P2] =
    {
        { xi.item.GOBLIN_BREW_P1, 8 },
    },

    [xi.item.KRAKEN_CLUB_P1] =
    {
        { xi.item.AETHER_FRAGMENT, 99 },
        { xi.item.OXBLOOD_ORB,     12 },
        { xi.item.ANGEL_SKIN_ORB,  12 },
        { xi.item.SLIMY_TENTACLE,   1 },
        { xi.item.KRAKEN_CLUB,      1 },
    },

    [xi.item.BRUTAL_EARRING_P1] =
    {
        { xi.item.AETHER_FRAGMENT,    50 },
        { xi.item.OXBLOOD_ORB,         5 },
        { xi.item.ANGEL_SKIN_ORB,      5 },
        { xi.item.MALIYAKALEYA_CORAL,  1 },
        { xi.item.BRUTAL_EARRING,      1 },
    },

    [xi.item.WARWOLF_BELT_P1] =
    {
        { xi.item.AETHER_FRAGMENT,    50 },
        { xi.item.BEHEMOTH_LEATHER,    5 },
        { xi.item.OVINNIK_LEATHER,     5 },
        { xi.item.SIFS_LOCK,           1 },
        { xi.item.WARWOLF_BELT,        1 },
    },
}

local synergyUpgrade =
{
    [xi.item.SAINTLY_MAIL] =
    {
        item = xi.item.REVEREND_MAIL,
        augs = { 1, 29, 49, 2, 142, 2 },
        mats =
        {
            { xi.item.AETHER_FRAGMENT,    50 },
            { xi.item.DAMASCUS_INGOT,      5 },
            { xi.item.TITANIUM_INGOT,      5 },
            { xi.item.BERYLLIUM_INGOT,     1 },
            { xi.item.REVEREND_MAIL,       1 },
        },
    },
}

local announce =
{
    [xi.item.KRAKEN_CLUB_P1] = "Kraken Club",
}

local skyUpgrades =
{
    {
        name     = "Genmei Shield",
        itemID   = xi.item.GENBUS_SHIELD,
        scrapID  = 3275,
        resultID = 27645, -- Genmei Shield
        augments = { 329, 4, 323, 4 }, -- Cure Potency +5% / Cure cast time -5%
    },
    {
        name     = "Shukuyu's Scythe",
        itemID   = xi.item.SUZAKUS_SCYTHE,
        scrapID  = 3276,
        resultID = 20893, -- Shukuyu's Scythe
        augments = { 25, 9, 512, 4 }, -- Attack+10 / STR+5
    },
    {
        name     = "Koboto",
        itemID   = xi.item.SEIRYUS_SWORD,
        scrapID  = 3277,
        resultID = 20699, -- Koboto
        augments = { 25, 9, 146, 4 }, -- Attack+10 / Dual Wield +5
    },
    {
        name     = "Jokushuono",
        itemID   = xi.item.BYAKKOS_AXE,
        scrapID  = 3278,
        resultID = 20846, -- Jokushuono
        augments = { 25, 9, 41, 2 }, -- Attack+10 / Crit.hit rate +3%
    },
}

local sky2Upgrades =
{
    {
        name       = "Reiki Osode",
        resultID   = xi.item.REIKI_OSODE,
        brokenID   = xi.item.TATTERED_OSODE,
        materialID = xi.item.MULCIBARS_SCORIA,
        itemID     = xi.item.KIRINS_OSODE,
        augments   = { 143, 2, 328, 2 }, -- Double Attack +3% / Crit hit damage +3%
    },
    {
        name       = "Genmei Kabuto",
        resultID   = xi.item.GENMEI_KABUTO,
        brokenID   = xi.item.CRACKED_KABUTO,
        materialID = xi.item.DIVINE_LUMBER,
        itemID     = xi.item.GENBUS_KABUTO,
        augments   = { 49, 2, 54, 4 }, -- Haste+3% / Phys. dmg. taken -5%
    },
    {
        name       = "Kobo Kote",
        resultID   = xi.item.KOBO_KOTE,
        brokenID   = xi.item.RUINED_KOTE,
        materialID = xi.item.DAMASCUS_INGOT,
        itemID     = xi.item.SEIRYUS_KOTE,
        augments   = { 142, 4, 41, 2 }, -- Store TP+5 / Critical hit rate+3%
    },
    {
        name       = "Jokushu Haidate",
        resultID   = xi.item.JOKUSHU_HAIDATE,
        brokenID   = xi.item.RIPPED_HAIDATE,
        materialID = xi.item.BEHEMOTH_LEATHER,
        itemID     = xi.item.BYAKKOS_HAIDATE,
        augments   = { 142, 4, 328, 2 }, -- Store TP+5 / Critical hit damage +3%
    },
    {
        name       = "Shukuyu Sune-Ate",
        resultID   = xi.item.SHUKUYU_SUNE_ATE,
        brokenID   = xi.item.SCUFFED_SUNE_ATE,
        materialID = xi.item.SIRENS_MACRAME,
        itemID     = xi.item.SUZAKUS_SUNE_ATE,
        augments   = { 49, 2, 140, 3 }, -- Haste+3% / Fast Cast +4%
    },
}

local validTrades =
{
-- [index] = { gear, soul, guaranteed augment, value min, value max, type },
    [  1] = { 12434, 3275,  49, 0, 0, resultType.SPECIAL }, -- *Genbu's Kabuto*               Haste
    [  2] = { 12296, 3275, 329, 0, 2, resultType.SPECIAL }, -- *Genbu's Shield*               Cure Potency
    [  3] = { 12946, 3276,  49, 0, 0, resultType.SPECIAL }, -- *Suzaku's Sune-Ate*            Haste
    [  4] = { 18043, 3276,  25, 0, 7, resultType.SPECIAL }, -- *Suzaku's Scythe*              Attack Damage
    [  5] = { 12690, 3277, 142, 0, 2, resultType.SPECIAL }, -- *Seiryu's Kote*                Store TP
    [  6] = { 17659, 3277,  25, 0, 7, resultType.SPECIAL }, -- *Seiryu's Sword*               Attack Damage
    [  7] = { 12818, 3278, 142, 0, 2, resultType.SPECIAL }, -- *Byakko's Haidate*             Store TP
    [  8] = { 18198, 3278,  25, 0, 7, resultType.SPECIAL }, -- *Byakko's Axe*                 Attack Damage

    [  9] = { 13876, 3283, 133, 0, 2, resultType.REGULAR }, -- *Zenith Crown*                 Magic Attack Bonus
    [ 10] = { 13877, 3283, 133, 1, 3, resultType.HIGH_Q  }, -- *Zenith Crown +1*              Magic Attack Bonus
    [ 11] = { 13787, 3283, 351, 0, 0, resultType.REGULAR }, -- *Dalmatica*                    Occasionally Quickens Spellcasting
    [ 12] = { 13788, 3283, 351, 0, 0, resultType.HIGH_Q  }, -- *Dalmatica +1*                 Occasionally Quickens Spellcasting
    [ 13] = { 14006, 3283, 516, 0, 2, resultType.REGULAR }, -- *Zenith Mitts*                 INT
    [ 14] = { 14007, 3283, 516, 1, 3, resultType.HIGH_Q  }, -- *Zenith Mitts +1*              INT
    [ 15] = { 14247, 3283, 322, 0, 2, resultType.REGULAR }, -- *Zenith Slacks*                Song Spellcasting Time
    [ 16] = { 14248, 3283, 322, 1, 3, resultType.HIGH_Q  }, -- *Zenith Slacks +1*             Song Spellcasting Time
    [ 17] = { 14123, 3283, 294, 0, 2, resultType.REGULAR }, -- *Zenith Pumps*                 Summoning Magic Skill
    [ 18] = { 14124, 3283, 294, 1, 3, resultType.HIGH_Q  }, -- *Zenith Pumps +1*              Summoning Magic Skill

    [ 19] = { 13927, 3279, 143, 0, 0, resultType.REGULAR }, -- *Hecatomb Cap*                 Double Attack
    [ 20] = { 13928, 3279, 143, 0, 1, resultType.HIGH_Q  }, -- *Hecatomb Cap +1*              Double Attack
    [ 21] = { 14378, 3279, 513, 0, 2, resultType.REGULAR }, -- *Hecatomb Harness*             DEX
    [ 22] = { 14379, 3279, 513, 1, 3, resultType.HIGH_Q  }, -- *Hecatomb Harness +1*          DEX
    [ 23] = { 14076, 3279, 328, 0, 0, resultType.REGULAR }, -- *Hecatomb Mittens*             Crit. Hit Damage
    [ 24] = { 14077, 3279, 328, 0, 1, resultType.HIGH_Q  }, -- *Hecatomb Mittens +1*          Crit. Hit Damage
    [ 25] = { 14308, 3279,  41, 0, 0, resultType.REGULAR }, -- *Hecatomb Subligar*            Crit. Hit Rate
    [ 26] = { 14309, 3279,  41, 0, 1, resultType.HIGH_Q  }, -- *Hecatomb Subligar +1*         Crit. Hit Rate
    [ 27] = { 14180, 3279, 512, 0, 2, resultType.REGULAR }, -- *Hecatomb Leggings*            STR
    [ 28] = { 14181, 3279, 512, 1, 3, resultType.HIGH_Q  }, -- *Hecatomb Leggings +1*         STR

    [ 29] = { 12421, 3280, 140, 0, 0, resultType.REGULAR }, -- *Koenig Schaller*              Fast Cast
    [ 30] = { 13911, 3280, 140, 0, 1, resultType.HIGH_Q  }, -- *Koenig Schaller +1*           Fast Cast
    [ 31] = { 12549, 3280,  54, 0, 0, resultType.REGULAR }, -- *Koenig Cuirass*               Physical Damage Taken
    [ 32] = { 14370, 3280,  54, 0, 1, resultType.HIGH_Q  }, -- *Koenig Cuirass +1*            Physical Damage Taken
    [ 33] = { 12677, 3280, 145, 0, 2, resultType.REGULAR }, -- *Koenig Handschuhs*            Counter
    [ 34] = { 14061, 3280, 145, 1, 3, resultType.HIGH_Q  }, -- *Koenig Handschuhs +1*         Counter
    [ 35] = { 12805, 3280,  55, 0, 0, resultType.REGULAR }, -- *Koenig Diechlings*            Magic Damage Taken
    [ 36] = { 14283, 3280,  55, 0, 1, resultType.HIGH_Q  }, -- *Koenig Diechlings +1*         Magic Damage Taken
    [ 37] = { 12933, 3280, 137, 0, 0, resultType.REGULAR }, -- *Koenig Schuhs*                Regen
    [ 38] = { 14163, 3280, 137, 0, 1, resultType.HIGH_Q  }, -- *Koenig Schuhs +1*             Regen

    [ 39] = { 12429, 3281, 293, 0, 2, resultType.REGULAR }, -- *Adaman Celata*                Dark Magic Skill
    [ 40] = { 13924, 3281, 293, 1, 3, resultType.HIGH_Q  }, -- *Adaman Celata +1*             Dark Magic Skill
    [ 41] = { 12557, 3281, 143, 0, 0, resultType.REGULAR }, -- *Adaman Hauberk*               Double Attack
    [ 42] = { 14371, 3281, 143, 0, 1, resultType.HIGH_Q  }, -- *Adaman Hauberk +1*            Double Attack
    [ 43] = { 12685, 3281,  49, 0, 0, resultType.REGULAR }, -- *Adaman Mufflers*              Haste
    [ 44] = { 14816, 3281,  49, 0, 1, resultType.HIGH_Q  }, -- *Adaman Mufflers +1*           Haste
    [ 45] = { 12813, 3281, 512, 0, 2, resultType.REGULAR }, -- *Adaman Breeches*              STR
    [ 46] = { 14296, 3281, 512, 1, 3, resultType.HIGH_Q  }, -- *Adaman Breeches +1*           STR
    [ 47] = { 12941, 3281, 111, 0, 2, resultType.REGULAR }, -- *Adaman Sollerets*             Pet: Haste
    [ 48] = { 14175, 3281, 111, 1, 3, resultType.HIGH_Q  }, -- *Adaman Sollerets +1*          Pet: Haste

    [ 49] = { 13934, 3282, 327, 0, 0, resultType.REGULAR }, -- *Shura Zunari Kabuto*          Weapon Skill Damage
    [ 50] = { 13935, 3282, 327, 0, 1, resultType.HIGH_Q  }, -- *Shura Zunari Kabuto +1*       Weapon Skill Damage
    [ 51] = { 14387, 3282,  49, 0, 0, resultType.REGULAR }, -- *Shura Togi*                   Haste
    [ 52] = { 14388, 3282,  49, 0, 1, resultType.HIGH_Q  }, -- *Shura Togi +1*                Haste
    [ 53] = { 14821, 3282, 145, 0, 2, resultType.REGULAR }, -- *Shura Kote*                   Counter
    [ 54] = { 14822, 3282, 145, 1, 3, resultType.HIGH_Q  }, -- *Shura Kote +1*                Counter
    [ 55] = { 14303, 3282, 146, 0, 0, resultType.REGULAR }, -- *Shura Haidate*                Dual Weild
    [ 56] = { 14304, 3282, 146, 0, 1, resultType.HIGH_Q  }, -- *Shura Haidate +1*             Dual Weild
    [ 57] = { 14184, 3282, 194, 0, 2, resultType.REGULAR }, -- *Shura Sune-Ate*               Kick Attacks
    [ 58] = { 14185, 3282, 194, 1, 3, resultType.HIGH_Q  }, -- *Shura Sune-Ate +1*            Kick Attacks

    [ 59] = { 13908, 3284,  35, 0, 2, resultType.REGULAR }, -- *Crimson Mask*                 Magic Accuracy
    [ 60] = { 13909, 3284,  35, 1, 3, resultType.HIGH_Q  }, -- *Crimson Mask +1*              Magic Accuracy
    [ 61] = { 14367, 3284,  49, 0, 0, resultType.REGULAR }, -- *Crimson Scale Mail*           Haste
    [ 62] = { 14368, 3284,  49, 0, 1, resultType.HIGH_Q  }, -- *Crimson Scale Mail +1*        Haste
    [ 63] = { 14058, 3284, 211, 0, 0, resultType.REGULAR }, -- *Crimson Finger Gauntlets*     Snapshot
    [ 64] = { 14059, 3284, 211, 0, 1, resultType.HIGH_Q  }, -- *Crimson Finger Gauntlets +1*  Snapshot
    [ 65] = { 14280, 3284, 140, 0, 0, resultType.REGULAR }, -- *Crimson Cuisses*              Fast Cast
    [ 66] = { 14281, 3284, 140, 0, 1, resultType.HIGH_Q  }, -- *Crimson Cuisses +1*           Fast Cast
    [ 67] = { 14160, 3284, 299, 0, 2, resultType.REGULAR }, -- *Crimson Greaves*              Blue Magic Skill
    [ 68] = { 14161, 3284, 299, 1, 3, resultType.HIGH_Q  }, -- *Crimson Greaves +1*           Blue Magic Skill

    [ 69] = { 16115, 3286, 101, 0, 0, resultType.REGULAR }, -- *Shadow Hat*                   Magic Attack Bonus
    [ 70] = { 16116, 3286, 101, 0, 1, resultType.HIGH_Q  }, -- *Shadow Hat +1*                Magic Attack Bonus
    [ 71] = { 14575, 3286,  35, 0, 1, resultType.REGULAR }, -- *Shadow Coat*                  Magic Accuracy
    [ 72] = { 14576, 3286,  35, 0, 2, resultType.HIGH_Q  }, -- *Shadow Coat +1*               Magic Accuracy
    [ 73] = { 14997, 3286, 133, 0, 0, resultType.REGULAR }, -- *Shadow Cuffs*                 Magic Attack Bonus
    [ 74] = { 14998, 3286, 133, 0, 1, resultType.HIGH_Q  }, -- *Shadow Cuffs +1*              Magic Attack Bonus
    [ 75] = { 15657, 3286, 133, 0, 0, resultType.REGULAR }, -- *Shadow Trews*                 Magic Attack Bonus
    [ 76] = { 15658, 3286, 133, 0, 1, resultType.HIGH_Q  }, -- *Shadow Trews +1*              Magic Attack Bonus
    [ 77] = { 15742, 3286, 296, 0, 2, resultType.REGULAR }, -- *Shadow Clogs*                 Singing Skill
    [ 78] = { 15743, 3286, 296, 1, 3, resultType.HIGH_Q  }, -- *Shadow Clogs +1*              Singing Skill

    [ 79] = { 16113, 3285, 138, 0, 0, resultType.REGULAR }, -- *Shadow Helm*                  Refresh
    [ 80] = { 16114, 3285, 138, 0, 0, resultType.HIGH_Q  }, -- *Shadow Helm +1*               Refresh
    [ 81] = { 14573, 3285, 144, 0, 0, resultType.REGULAR }, -- *Shadow Breastplate*           Triple Attack
    [ 82] = { 14574, 3285, 144, 0, 1, resultType.HIGH_Q  }, -- *Shadow Breastplate +1*        Triple Attack
    [ 83] = { 14995, 3285, 143, 0, 0, resultType.REGULAR }, -- *Shadow Gauntlets*             Double Attack
    [ 84] = { 14996, 3285, 143, 0, 1, resultType.HIGH_Q  }, -- *Shadow Gauntlets +1*          Double Attack
    [ 85] = { 15655, 3285,  49, 0, 0, resultType.REGULAR }, -- *Shadow Cuishes*               Haste
    [ 86] = { 15656, 3285,  49, 0, 1, resultType.HIGH_Q  }, -- *Shadow Cuishes +1*            Haste
    [ 87] = { 15740, 3285,  41, 0, 0, resultType.REGULAR }, -- *Shadow Sabatons*              Crit. Hit Rate
    [ 88] = { 15741, 3285,  41, 0, 1, resultType.HIGH_Q  }, -- *Shadow Sabatons +1*           Crit. Hit Rate

    [ 89] = { 12562, 3275, 137, 0, 0, resultType.KIRIN   }, -- *Kirin's Osode (Genbu)*        Regen
    [ 90] = { 12562, 3276, 143, 0, 0, resultType.KIRIN   }, -- *Kirin's Osode (Suzaku)*       Double Attack
    [ 91] = { 12562, 3277, 211, 0, 0, resultType.KIRIN   }, -- *Kirin's Osode (Seiryu)*       Snapshot
    [ 92] = { 12562, 3278, 146, 0, 0, resultType.KIRIN   }, -- *Kirin's Osode (Byakko)*       Dual Weild
    [ 93] = { 17567, 3275, 290, 0, 2, resultType.KIRIN   }, -- *Kirin's Pole (Genbu)*         Enhancing Magic Skill
    [ 94] = { 17567, 3276, 292, 0, 2, resultType.KIRIN   }, -- *Kirin's Pole (Suzaku)*        Elemental Magic Skill
    [ 95] = { 17567, 3277, 291, 0, 2, resultType.KIRIN   }, -- *Kirin's Pole (Seiryu)*        Enfeebling Magic Skill
    [ 96] = { 17567, 3278, 294, 0, 2, resultType.KIRIN   }, -- *Kirin's Pole (Byakko)*        Summoning Magic Skill

    -- 4 item trades
    [ 97] = { 19307, 2858,  25, 0, 6, resultType.REGULAR, 2858, 2859, }, -- *Sarissa*         Attack Damage
    [ 98] = { 19304, 2858,  25, 0, 7, resultType.REGULAR, 2858, 2859, }, -- *Sarissa*         Attack Damage
    [ 99] = { 18617, 2858,  35, 0, 8, resultType.REGULAR, 2858, 2859, }, -- *Majestas*        Magic Acc
    [100] = { 18603, 2858,  35, 0, 9, resultType.REGULAR, 2858, 2859, }, -- *Majestas*        Magic Acc
    [101] = { 19128, 2858,  25, 0, 1, resultType.REGULAR, 2859, 2859, }, -- *Machismo*        Attack Damage
    [102] = { 19118, 2858,  25, 0, 2, resultType.REGULAR, 2859, 2859, }, -- *Machismo*        Attack Damage

    -- 5 item trades
    [103] = { 19162, 2858,  25, 0, 6, resultType.REGULAR, 2858, 2858, 2859, }, -- *Galatyn*   Attack Damage
    [104] = { 19159, 2858,  25, 0, 7, resultType.REGULAR, 2858, 2858, 2859, }, -- *Galatyn*   Attack Damage
    [105] = { 17767, 2858,  25, 0, 1, resultType.REGULAR, 2858, 2859, 2859, }, -- *Concordia* Attack Damage
    [106] = { 17765, 2858,  25, 0, 2, resultType.REGULAR, 2858, 2859, 2859, }, -- *Concordia* Attack Damage
}

local augmentTable =
{
    [12434] = {  54, 195,  53,  31 }, -- *Genbu's Kabuto*
    [12296] = {  35, 323,  83,  79 }, -- *Genbu's Shield*
    [12946] = { 140, 134,  37, 117 }, -- *Suzaku's Sune-Ate*
    [18043] = {  49, 512, 516, 517 }, -- *Suzaku's Scythe*
    [12690] = {  41,  25,  23,  31 }, -- *Seiryu's Kote*
    [17659] = { 146, 515,  23,  41 }, -- *Seiryu's Sword* -- NOT RETAIL
    [12818] = { 328, 514, 515, 517 }, -- *Byakko's Haidate*
    [18198] = {  41, 514, 515, 133 }, -- *Byakko's Axe*

    [13927] = {  25, 514, 516, 518 }, -- *Hecatomb Cap*
    [13928] = {  25, 514, 516, 518 }, -- *Hecatomb Cap+1*
    [14378] = { 142, 333,  25, 115 }, -- *Hecatomb Harness*
    [14379] = { 142, 333,  25, 115 }, -- *Hecatomb Harness+1*
    [14076] = {  23, 258, 259, 261 }, -- *Hecatomb Mittens*
    [14077] = {  23, 258, 259, 261 }, -- *Hecatomb Mittens+1*
    [14308] = {  23, 195,  31,  96 }, -- *Hecatomb Subligar*
    [14309] = {  23, 195,  31,  96 }, -- *Hecatomb Subligar+1*
    [14180] = {  25, 264, 263, 262 }, -- *Hecatomb Leggings*
    [14181] = {  25, 264, 263, 262 }, -- *Hecatomb Leggings+1*

    [12421] = {  42, 153, 329,  56 }, -- *Koenig Schaller*
    [13911] = {  42, 153, 329,  56 }, -- *Kaiser Schaller*
    [12549] = { 141,  53,  39,  55 }, -- *Koenig Cuirass*
    [14370] = { 141,  53,  39,  55 }, -- *Kaiser Cuirass*
    [12677] = {  83, 286,  23,  39 }, -- *Koenig Handschuhs*
    [14061] = {  83, 286,  23,  39 }, -- *Kaiser Handschuhs*
    [12805] = {  31,  83, 288, 289 }, -- *Koenig Diechlings*
    [14283] = {  31,  83, 288, 289 }, -- *Kaiser Handschuhs*
    [12933] = {  49,  23,  25,  31 }, -- *Koenig Schuhs*
    [14163] = {  49,  23,  25,  31 }, -- *Kaiser Schuhs*

    [12429] = { 177, 141,  52,  35 }, -- *Adaman Celata*
    [13924] = { 177, 141,  52,  35 }, -- *Armada Celata*
    [12557] = {  83, 142, 195,  79 }, -- *Adaman Hauberk*
    [14371] = {  83, 142, 195,  79 }, -- *Armada Hauberk*
    [12685] = { 513, 514, 515, 518 }, -- *Adaman Mufflers*
    [14816] = { 513, 514, 515, 518 }, -- *Armada Mufflers*
    [12813] = { 107, 333,  40, 516 }, -- *Adaman Breeches*
    [14296] = { 107, 333,  40, 516 }, -- *Armada Breeches*
    [12941] = { 518, 324,  99, 116 }, -- *Adaman Sollerets*
    [14175] = { 518, 324,  99, 116 }, -- *Armada Sollerets*

    [13934] = { 513, 332, 333,  25 }, -- *Shura Zunari Kabuto*
    [13935] = { 513, 332, 333,  25 }, -- *Shura Zunari Kabuto+1*
    [14387] = { 195,  41, 215,  31 }, -- *Shura Togi*
    [14388] = { 195,  41, 215,  31 }, -- *Shura Togi+1*
    [14821] = {  42,  31,  53, 515 }, -- *Shura Kote*
    [14822] = {  42,  31,  53, 515 }, -- *Shura Kote+1*
    [14303] = {  27,  39, 142, 515 }, -- *Shura Haidate*
    [14304] = {  27,  39, 142, 515 }, -- *Shura Haidate+1*
    [14184] = { 514, 143, 512, 515 }, -- *Shura Sune-Ate*
    [14185] = { 514, 143, 512, 515 }, -- *Shura Sune-Ate+1*

    [13876] = { 288,  57, 290, 293 }, -- *Zenith Crown*
    [13877] = { 288,  57, 290, 293 }, -- *Zenith Crown+1*
    [13787] = { 119, 140, 133,  35 }, -- *Dalmatica*
    [13788] = { 119, 140, 133,  35 }, -- *Dalmatica+1*
    [14006] = { 100,  40, 334, 141 }, -- *Zenith Mitts*
    [14007] = { 100,  40, 334, 141 }, -- *Zenith Mitts+1*
    [14247] = {  51,  52, 298,  17 }, -- *Zenith Slacks*
    [14248] = {  51,  52, 298,  17 }, -- *Zenith Slacks+1*
    [14123] = { 101, 329, 323, 289 }, -- *Zenith Pumps*
    [14124] = { 101, 329, 323, 289 }, -- *Zenith Pumps+1*

    [13908] = { 517,  27, 515, 362 }, -- *Crimson Mask*
    [13909] = { 517,  27, 515, 362 }, -- *Crimson Mask+1*
    [14367] = { 518, 512, 515,  23 }, -- *Crimson Scale Mail*
    [14368] = { 518, 512, 515,  23 }, -- *Crimson Scale Mail+1*
    [14058] = { 517, 282, 195,  40 }, -- *Crimson Finger Gauntlets*
    [14059] = { 517, 282, 195,  40 }, -- *Crimson Finger Gauntlets+1*
    [14280] = { 514,  31, 134,  37 }, -- *Crimson Cuisses*
    [14281] = { 514,  31, 134,  37 }, -- *Crimson Cuisses+1*
    [14160] = { 195,  23, 332, 142 }, -- *Crimson Greaves*
    [14161] = { 195,  23, 332, 142 }, -- *Crimson Greaves+1*

    [16113] = { 516, 517,  39,  55 }, -- *Shadow Helm*
    [16114] = { 516, 517,  39,  55 }, -- *Valkyrie's Helm*
    [14573] = { 198,  23, 134,  37 }, -- *Shadow Breastplate*
    [14574] = { 198,  23, 134,  37 }, -- *Valkyrie's Breastplate*
    [14995] = { 512, 260, 262, 263 }, -- *Shadow Gauntlets*
    [14996] = { 512, 260, 262, 263 }, -- *Valkyrie's Gauntlets*
    [15655] = { 293, 512, 514, 515 }, -- *Shadow Cuishes*
    [15656] = { 293, 512, 514, 515 }, -- *Valkyrie's Cuishes*
    [15740] = { 328, 195,  31,  27 }, -- *Shadow Sabatons*
    [15741] = { 328, 195,  31,  27 }, -- *Valkyrie's Sabatons*

    [16115] = { 297, 292, 290, 100 }, -- *Shadow Hat*
    [16116] = { 297, 292, 290, 100 }, -- *Valkyrie's Hat*
    [14575] = {  57, 516, 517, 518 }, -- *Shadow Coat*
    [14576] = {  57, 516, 517, 518 }, -- *Valkyrie's Coat*
    [14997] = { 141,  53,  83, 101 }, -- *Shadow Cuffs*
    [14998] = { 141,  53,  83, 101 }, -- *Valkyrie's Cuffs*
    [15657] = { 292,  97, 102, 141 }, -- *Shadow Trews*
    [15658] = { 292,  97, 102, 141 }, -- *Valkyrie's Trews*
    [15742] = {  83, 288, 293, 291 }, -- *Shadow Clogs*
    [15743] = {  83, 288, 293, 291 }, -- *Valkyrie's Clogs*

    [19304] = {  23, 513, 512, 188 }, -- *Sarissa*
    [18603] = { 133,  83, 516, 141 }, -- *Majestas*
    [19159] = {  23, 513, 512, 188 }, -- *Galatyn*
    [17765] = {  23, 299, 332, 512 }, -- *Concordia*
    [19118] = {  23, 512, 513, 515 }, -- *Machismo*

    b1 = {  54,  25, 23,  31 }, -- *Kirin's Osode (Genbu)*
    b2 = { 328,  25, 23,  31 }, -- *Kirin's Osode (Suzaku)*
    b3 = {  29,  31, 23,  25 }, -- *Kirin's Osode (Seiryu)*
    b4 = {  41,  25, 23,  31 }, -- *Kirin's Osode (Byakko)*
    w1 = {  25,  23, 79, 514 }, -- *Kirin's Pole (Genbu)*
    w2 = {  25,  23, 83, 512 }, -- *Kirin's Pole (Suzaku)*
    w3 = {  25,  23, 83, 515 }, -- *Kirin's Pole (Seiryu)*
    w4 = {  79,  25, 23, 513 }, -- *Kirin's Pole (Byakko)*
}

local randomAug =
{
    r1 = { 768, 769, 770, 771, 772, 773, 774, 775 },
    --Resist Fire, Earth, Water, Wind, Thunder, Ice, Light, or Darkness
    r2 = { 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188 },
    --Resist Sleep, Poison, Paralyze, Blind, Silence, Virus, Petrify, Bind, Curse, Gravity, Slow, Stun, Charm
    r3 = { 133,  35,  25,  23,  27,  29,  31,  37 },
    -- M.atk./M.acc/Atk./Acc/R.atk/R.acc/Eva./M.Eva
    r4 = { 512, 513, 514, 515, 516, 517, 518 },
    -- STR/DEX/INT/MND/CHR/VIT/AGI
}

local craftingStallRequirements =
{
--   [x] = {item1, Qty1, item2, Qty2, item3, Qty3, item4, Qty4, item5, Qty5, item6, Qty6, item7, Qty7 },
    [ 1] = { 4104,   12,   662,    3,   718,    2,   829,    1,  2000,    1,  3324,    1 },              -- Fire Cluster, Iron Sheet, Rosewood Lumber, Silk Cloth, Dark Adaman Ingot, Blacksmiths' Emblem
    [ 2] = { 4110,   12,   662,    3,   718,    2,   829,    1,   743,    1,  3325,    1 },              -- Light Cluster, Iron Sheet, Rosewood Lumber, Silk Cloth, Phrygian Gold Ingot, Goldsmiths' Emblem
    [ 3] = { 4111,   12,   662,    3,   718,    2,   829,    1,  2147,    1,  3326,    1 },              -- Dark Cluster, Iron Sheet, Rosewood Lumber, Silk Cloth, Marid Tusk, Boneworkers' Emblem
    [ 4] = { 4107,   12,   654,    1,   708,    3,   745,    1,  1829,    1,  2200,    1,  3327,    1 }, -- Earth Cluster, Darksteel Ingot, Maple Lumber, Gold Ingot, Red Grass Cloth, Twill Damask, Weavers' Emblem
    [ 5] = { 4106,   12,   654,    1,   708,    3,   745,    1,  1829,    1,  4387,    1,  3328,    1 }, -- Wind Cluster, Darksteel Ingot, Maple Lumber, Gold Ingot, Red Grass Cloth, Wild Onion, Culinarians' Emblem
    [ 6] = { 4105,   12,   654,    1,   708,    3,   745,    1,  1829,    1,  1117,    1,  3329,    1 }, -- Ice Cluster, Darksteel Ingot, Maple Lumber, Gold Ingot, Red Grass Cloth, Manticore Leather, Tanners' Emblem
    [ 7] = { 4109,   12,   709,    1,   716,    4,   824,    1, 17388,    1,  3330,    1 },              -- Water Cluster, Beech Lumber, Oak Lumber, Grass Cloth, Fastwater Fishing Rod, Fishermen's Emblem
    [ 8] = { 4107,   12,   709,    1,   716,    4,   824,    1,  1657,    1,  3331,    1 },              -- Earth Cluster, Beech Lumber, Oak Lumber, Grass Cloth, Bundling Twine, Carpenters' Emblem
    [ 9] = { 4108,   12,   709,    1,   716,    4,   824,    1,  4145,    1,  3332,    1 },              -- Lightning cluster, Beech Lumber, Oak Lumber, Grass Cloth, Elixir, Alchemists' Emblem
}

local craftingSmocks =
{
--   [x] = {item1, Qty1, item2, Qty2},
    [ 1] = { 4107,   12,   14392,    1 }, -- Earth Cluster, Carpenters Apron
    [ 2] = { 4104,   12,   14393,    1 }, -- Fire Cluster, Blacksmiths Apron
    [ 3] = { 4110,   12,   14394,    1 }, -- Light Cluster, Goldsmiths Apron
    [ 4] = { 4107,   12,   14395,    1 }, -- Earth Cluster, Weavers Apron
    [ 5] = { 4105,   12,   14396,    1 }, -- Ice Cluster,  Tanners Apron
    [ 6] = { 4111,   12,   14397,    1 }, -- Dark Cluster, Boneworkers Apron
    [ 7] = { 4108,   12,   14398,    1 }, -- Lightning Cluster, Alchemists Apron
    [ 8] = { 4106,   12,   14399,    1 }, -- Wind Cluster, Culinarians Apron
    [ 9] = { 4109,   12,   14400,    1 }, -- Water Cluster, Fishermans Apron
}

local augmentLimitsHQ =
{
    [ 41] = 2, -- Critical Hit Rate 1~3%
    [ 49] = 2, -- Haste 1~3%
    [ 57] = 3, -- Magic Critical Hit rate 1~4%
    [137] = 2, -- Regen 1~3
    [138] = 0, -- Refresh 1
    [140] = 3, -- Fast Cast 1~4%
    [143] = 2, -- Double Attack 1~3%
    [144] = 2, -- Triple Attack 1~3%
    [211] = 2, -- Snapshot 1~3
    [328] = 2  -- Critical Hit Damage 1~3%
}

local augmentLimitsNQ =
{
    [ 41] = 1, -- Critical Hit Rate 1~2%
    [ 49] = 1, -- Haste 1~2%
    [ 57] = 2, -- Magic Critical Hit rate 1~3%
    [137] = 1, -- Regen 1~2
    [138] = 0, -- Refresh 1
    [140] = 2, -- Fast Cast 1~3%
    [143] = 1, -- Double Attack 1~2%
    [144] = 1, -- Triple Attack 1~2%
    [211] = 1, -- Snapshot 1~2
    [328] = 1  -- Critical Hit Damage 1~2%
}

local fomorWeapons =
{
    [19307] = 19304, -- *Sarissa*
    [18617] = 18603, -- *Majestas*
    [19128] = 19118, -- *Machismo*
    [19162] = 19159, -- *Galatyn*
    [17767] = 17765, -- *Concordia*
}

local function synergyResult(player, npc, itemID)
    player:tradeComplete()
    player:addItem(itemID)

    npc:independentAnimation(player, 35, 4)

    player:timer(1500, function()
        player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemID)
    end)
end

------------------------------------------------------------
-- Limit power of HQ augments
------------------------------------------------------------
local function limitPowerHQ(aug, pow)
    if augmentLimitsHQ[aug] then
        if augmentLimitsHQ[aug] > 0 then
            pow = math.random(0, augmentLimitsHQ[aug])
        else
            pow = 0
        end
    end
    return pow
end

------------------------------------------------------------
-- Limit power of NQ augments
------------------------------------------------------------
local function limitPowerNQ(aug, pow)
    if augmentLimitsNQ[aug] then
        if augmentLimitsNQ[aug] > 0 then
            pow = math.random(0, augmentLimitsNQ[aug])
        else
            pow = 0
        end
    end
    return pow
end

------------------------------------------------------------
-- Handle Kirin Item Creation
------------------------------------------------------------
local function handleKirinItemCreation(player, itemId, aug0, pow0)
    -- Define augment variables.
    local aug1 = 0
    local pow1 = math.random(0, 2)
    local aug2 = 0
    local pow2 = 0

    -- Define augment 1 and 2 based on item and existing augment 0.
    if itemId == 12562 then
        if aug0 == 137 then
            aug1 = augmentTable.b1[math.random(1, 4)]
            aug2 = augmentTable.b1[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.b1[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        elseif aug0 == 143 then
            aug1 = augmentTable.b2[math.random(1, 4)]
            aug2 = augmentTable.b2[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.b2[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        elseif aug0 == 146 then
            aug1 = augmentTable.b4[math.random(1, 4)]
            aug2 = augmentTable.b4[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.b4[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        elseif aug0 == 211 then
            aug1 = augmentTable.b3[math.random(1, 4)]
            aug2 = augmentTable.b3[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.b3[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        end

    elseif itemId == 17567 then
        if aug0 == 290 then
            aug1 = augmentTable.w1[math.random(1, 4)]
            aug2 = augmentTable.w1[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.w1[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        elseif aug0 == 291 then
            aug1 = augmentTable.w3[math.random(1, 4)]
            aug2 = augmentTable.w3[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.w3[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        elseif aug0 == 292 then
            aug1 = augmentTable.w2[math.random(1, 4)]
            aug2 = augmentTable.w2[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.w2[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        elseif aug0 == 294 then
            aug1 = augmentTable.w4[math.random(1, 4)]
            aug2 = augmentTable.w4[math.random(1, 4)]
            if aug1 == aug2 then
                repeat aug2 = augmentTable.w4[math.random(1, 4)]
                until(aug2 ~= aug1)
            end
        end
    end

    -- Roll for quality.
    local qualityRoll = math.random(1, 100)

    if qualityRoll > 90 then     -- Add +2 to augment 0, 1 and 2 power.
        pow0 = pow0 + 2
        pow1 = pow1 + 2
        pow2 = math.random(0, 2) + 2
        player:printToPlayer( "You have reached a HQ3 Augment!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 85 then -- Remove Augment 2. Add +1 to Augment 0 and 1 power.
        pow0 = pow0 + 1
        pow1 = pow1 + 1
        player:printToPlayer( "You have reached a HQ2 Augment!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 15 then -- Remove Augment 2.
        aug2 = nil
        pow2 = nil
        player:printToPlayer( "You have reached a HQ1 Augment!", xi.msg.channel.SYSTEM_3 )
    else                         -- Remove Augment 0 and 2.
        aug0 = nil
        pow0 = nil
        aug2 = nil
        pow2 = nil
        player:printToPlayer( "The Furnace has spoken! You can have the damaged NQ remains!", xi.msg.channel.SYSTEM_3 )
    end

    pow0 = limitPowerHQ(aug0, pow0) -- Limit power
    pow1 = limitPowerHQ(aug1, pow1) -- Limit power
    pow2 = limitPowerHQ(aug2, pow2) -- Limit power
    player:tradeComplete()
    player:addItem(itemId, 1, aug0, pow0, aug1, pow1, aug2, pow2)
    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemId)
end

------------------------------------------------------------
-- Handle HQ Item Creation
------------------------------------------------------------
local function handleHqItemCreation(player, itemId, aug0, pow0) -- This is for HQ items. Augment 0 will carry over from our NPC trade function.
    -- Define augment variables.
    local aug1 = augmentTable[itemId][math.random(1, 4)] -- Augment 1 happens always, so we define it now.
    local pow1 = math.random(0, 3)
    local aug2 = nil
    local pow2 = nil

    -- Roll for quality.
    local qualityRoll = math.random(1, 100)

    if qualityRoll > 90 then -- Add +2 to Augment 0, 1 and 2 power.
        pow0 = pow0 + 2
        pow1 = pow1 + 2
        aug2 = augmentTable[itemId][math.random(1, 4)]
        pow2 = 2 + math.random(0, 3)

        player:printToPlayer( "You have reached a HQ3 Augment(HQ)!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 85 then -- Remove Augment 2. Add +1 to Augment 0 and Augment 1 power.
        pow0 = pow0 + 1
        pow1 = pow1 + 1

        player:printToPlayer( "You have reached a HQ2 Augment(HQ)!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 15 then -- Remove Augment 2.
        player:printToPlayer( "You have reached a HQ1 Augment(HQ)!", xi.msg.channel.SYSTEM_3 )
    else -- Remove Augment 0.
        aug0 = nil
        pow0 = nil
        aug2 = augmentTable[itemId][math.random(1, 4)]
        pow2 = math.random(0, 3)

        player:printToPlayer( "The Furnace has spoken! You can have the crispy NQ remains!", xi.msg.channel.SYSTEM_3 )
    end

    if aug1 == aug2 then -- Check if augments are equal in value. If so we will reroll
        repeat aug2 = augmentTable[itemId][math.random(1, 4)]
        until(aug2 ~= aug1)
    end

    pow0 = limitPowerHQ(aug0, pow0) -- Limit power
    pow1 = limitPowerHQ(aug1, pow1) -- Limit power
    pow2 = limitPowerHQ(aug2, pow2) -- Limit power
    player:tradeComplete()
    player:addItem(itemId, 1, aug0, pow0, aug1, pow1, aug2, pow2)
    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemId)
end

------------------------------------------------------------
-- Handle Augmented Item Creation
------------------------------------------------------------
local function handleAugmentedItemCreation(player, itemId, aug0, pow0)
    -- Define augment variables.
    local aug1 = augmentTable[itemId][math.random(1, 4)] -- Augment 1 happens always, so we define it now.
    local pow1 = math.random(0, 2)
    local aug2 = nil -- Augment 2 only happens 1 time, so we assume nil.
    local pow2 = nil

    -- Roll for quality.
    local qualityRoll = math.random(1, 100)

    if qualityRoll > 90 then     -- Add +2 to augment 0, 1 and 2 power.
        pow0 = pow0 + 2
        pow1 = pow1 + 2
        aug2 = augmentTable[itemId][math.random(1, 4)]
        pow2 = 2 + math.random(0, 2)
        if aug1 == aug2 then
            repeat aug2 = augmentTable[itemId][math.random(1, 4)]
            until(aug2 ~= aug1)
        end
        player:printToPlayer( "You have reached a HQ3 Augment!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 85 then -- Remove Augment 2. Add +1 to Augment 0 and 1 power.
        pow0 = pow0 + 1
        pow1 = pow1 + 1
        player:printToPlayer( "You have reached a HQ2 Augment!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 15 then -- Remove Augment 2.
        player:printToPlayer( "You have reached a HQ1 Augment!", xi.msg.channel.SYSTEM_3 )
    else                         -- Remove Augment 0 and 2.
        aug0 = nil
        pow0 = nil
        player:printToPlayer( "The Furnace has spoken! You can have the damaged NQ remains!", xi.msg.channel.SYSTEM_3 )
    end

    pow0 = limitPowerNQ(aug0, pow0) -- Limit power
    pow1 = limitPowerNQ(aug1, pow1) -- Limit power
    pow2 = limitPowerNQ(aug2, pow2) -- Limit power
    player:tradeComplete()
    player:addItem(itemId, 1, aug0, pow0, aug1, pow1, aug2, pow2)
    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemId)
end

------------------------------------------------------------
-- Handle Special Augmented Item Creation (Items that are giving + values outside of adjustments)
------------------------------------------------------------
local function handleSpecialAugmentedItemCreation(player, itemId, aug0, pow0)
    -- Define augment variables.
    local aug1 = augmentTable[itemId][math.random(1, 4)] -- Augment 1 happens always, so we define it now.
    local pow1 = math.random(0, 2)
    local aug2 = nil -- Augment 2 only happens 1 time, so we assume nil.
    local pow2 = nil

    -- Roll for quality.
    local qualityRoll = math.random(1, 100)

    if qualityRoll > 90 then     -- Add +2 to augment 0, 1 and 2 power.
        pow0 = pow0 + 2
        pow1 = pow1 + 2
        aug2 = augmentTable[itemId][math.random(1, 4)]
        pow2 = 2 + math.random(0, 2)
        if aug1 == aug2 then
            repeat aug2 = augmentTable[itemId][math.random(1, 4)]
            until(aug2 ~= aug1)
        end
        player:printToPlayer( "You have reached a HQ3 Augment!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 85 then -- Remove Augment 2. Add +1 to Augment 0 and 1 power.
        pow0 = pow0 + 1
        pow1 = pow1 + 1
        player:printToPlayer( "You have reached a HQ2 Augment!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll > 15 then -- Remove Augment 2.
        player:printToPlayer( "You have reached a HQ1 Augment!", xi.msg.channel.SYSTEM_3 )
    else                         -- Remove Augment 0 and 2.
        aug0 = nil
        pow0 = nil
        player:printToPlayer( "The Furnace has spoken! You can have the damaged NQ remains!", xi.msg.channel.SYSTEM_3 )
    end

    pow0 = limitPowerHQ(aug0, pow0) -- Limit power
    pow1 = limitPowerHQ(aug1, pow1) -- Limit power
    pow2 = limitPowerHQ(aug2, pow2) -- Limit power
    player:tradeComplete()
    player:addItem(itemId, 1, aug0, pow0, aug1, pow1, aug2, pow2)
    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemId)
end

------------------------------------------------------------
-- Handle Random Augments
------------------------------------------------------------
local function handleRandomAugment(player, itemId, aug0, pow0)
    -- Define augment variables.
    local aug1 = 0
    local pow1 = 0
    local aug2 = 0
    local pow2 = 0

    -- Roll for quality.
    local qualityRoll = math.random(1, 4)

    if qualityRoll == 1 then     -- Nullify augments 0 and 1.
        aug0 = nil
        pow0 = nil
        aug1 = nil
        pow1 = nil
        player:printToPlayer( "Your item has been damaged! A Random Augment has remained!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll == 2 then -- Nullify augment 1.
        aug1 = nil
        pow1 = nil
        player:printToPlayer( "Randomizing your items base Augment with a Randomly selected Augment!", xi.msg.channel.SYSTEM_3 )
    elseif qualityRoll == 3 then -- Nullify augment 2.
        aug2 = nil
        pow2 = nil
        player:printToPlayer( "You have lost the Random Augment! Your item was saved by the Furnace!", xi.msg.channel.SYSTEM_3 )
    else                         -- Enhances augment 0 and 1 power.
        pow0 = pow0 + 2
        pow1 = 2
        player:printToPlayer( "You have reached a HQ Random Augment! The Furnace approves!", xi.msg.channel.SYSTEM_3 )
    end

    -- Augment 1 work.
    if qualityRoll >= 3 then
        if itemId == 12562 then -- Kirin's Osode
            if aug0 == 137 then
                aug1 = augmentTable.b1[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            elseif aug0 == 143 then
                aug1 = augmentTable.b2[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            elseif aug0 == 211 then
                aug1 = augmentTable.b3[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            elseif aug0 == 146 then
                aug1 = augmentTable.b4[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            end
        elseif itemId == 17567 then -- Kirin's Pole
            if aug0 == 290 then
                aug1 = augmentTable.w1[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            elseif aug0 == 292 then
                aug1 = augmentTable.w2[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            elseif aug0 == 291 then
                aug1 = augmentTable.w3[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            elseif aug0 == 294 then
                aug1 = augmentTable.w4[math.random(1, 4)] -- We will randomly select a augment from our [itemId] = {table}
            end
        else
            aug1 = augmentTable[itemId][math.random(1, 4)]
        end

        -- Set power.
        pow1 = pow1 + math.random(0, 2)
    end

    -- Augment 2 work.
    if qualityRoll ~= 3 then
        local augmentRoll = math.random(1, 6) -- How we pick a random augment table (4 tables and 2 for HP and or MP)

        if augmentRoll == 1 then
            aug2 = randomAug.r1[math.random(1, 8)]
            if aug2 == aug0 or aug2 == aug1 then
                repeat aug2 = randomAug.r1[math.random(1, 8)]
                until(aug2 ~= aug0 and aug2 ~= aug1)
            end
        elseif augmentRoll == 2 then
            aug2 = randomAug.r2[math.random(1, 13)]
            if aug2 == aug0 or aug2 == aug1 then
                repeat aug2 = randomAug.r2[math.random(1, 13)]
                until(aug2 ~= aug0 and aug2 ~= aug1)
            end
        elseif augmentRoll == 3 then
            aug2 = randomAug.r3[math.random(1, 8)]
            if aug2 == aug0 or aug2 == aug1 then
                repeat aug2 = randomAug.r3[math.random(1, 8)]
                until(aug2 ~= aug0 and aug2 ~= aug1)
            end
        elseif augmentRoll == 4 then
            aug2 = randomAug.r4[math.random(1, 7)]
            if aug2 == aug0 or aug2 == aug1 then
                repeat aug2 = randomAug.r4[math.random(1, 7)]
                until(aug2 ~= aug0 and aug2 ~= aug1)
            end
        elseif augmentRoll == 5 then -- HP+ augment.
            aug2 = 79
        elseif augmentRoll == 6 then -- MP+ augment.
            aug2 = 83
        end

        -- Set power.
        pow2 = math.random(0, 4)
    end

    pow0 = limitPowerNQ(aug0, pow0) -- Limit power
    pow1 = limitPowerNQ(aug1, pow1) -- Limit power
    pow2 = limitPowerNQ(aug2, pow2) -- Limit power
    player:tradeComplete()
    player:addItem(itemId, 1, aug0, pow0, aug1, pow1, aug2, pow2)
    player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, itemId)
end

-----------------------------------
-- Public functions
-----------------------------------
local function onTrigger(player)
    if not cexi.hasSetting(player, cexi.setting.SKIP_FURNACE_RP) then
        player:fmt("The Synergy Furnace has collected enough souls to remain operational, for now ...")
    else
        player:fmt("The Synergy Furnace appears to be operational.")
    end
end

local function onTrade(player, npc, trade)
    ----------------------------------------------------------------------------------------------
    -- Crafting Track Suit
    ----------------------------------------------------------------------------------------------
    local fireclusters = npcUtil.tradeHas(trade, {{ 4104, 12 }})

    if fireclusters then
        if npcUtil.tradeHas(trade, 27325, 27325) then
            return synergyResult(player, npc, 27326) -- Give Track Pants +1
        elseif npcUtil.tradeHas(trade, 25713, 25713) then
            return synergyResult(player, npc, 25714) -- Give Track Shirt +1
        end
    end

    ----------------------------------------------------------------------------------------------
    -- Crafting Smocks
    ----------------------------------------------------------------------------------------------
    local craftingSmock = 0

    for i = 1, 9 do -- This variable "i" will be the index in the table.
        craftingSmock = 11328 + i

        if
            npcUtil.tradeHasExactly(trade,
            {
                {craftingSmocks[i][1], craftingSmocks[i][2]},
                {craftingSmocks[i][3], craftingSmocks[i][4]},
            })
        then
            return synergyResult(player, npc, craftingSmock)
        end
    end

    ----------------------------------------------------------------------------------------------
    -- Crafting Stalls
    ----------------------------------------------------------------------------------------------
    local craftingStall = 0

    for i = 1, 9 do -- This variable "i" will be the index in the table.
        craftingStall = 3624 + i

        if i >= 4 and i <= 6 then
            if
                npcUtil.tradeHasExactly(trade,
                {
                    { craftingStallRequirements[i][1],  craftingStallRequirements[i][2]  },
                    { craftingStallRequirements[i][3],  craftingStallRequirements[i][4]  },
                    { craftingStallRequirements[i][5],  craftingStallRequirements[i][6]  },
                    { craftingStallRequirements[i][7],  craftingStallRequirements[i][8]  },
                    { craftingStallRequirements[i][9],  craftingStallRequirements[i][10] },
                    { craftingStallRequirements[i][11], craftingStallRequirements[i][12] },
                    { craftingStallRequirements[i][13], craftingStallRequirements[i][14] },
                })
            then
                return synergyResult(player, npc, craftingStall)
            end
        else
            if
                npcUtil.tradeHasExactly(trade,
                {
                    { craftingStallRequirements[i][1],  craftingStallRequirements[i][2]  },
                    { craftingStallRequirements[i][3],  craftingStallRequirements[i][4]  },
                    { craftingStallRequirements[i][5],  craftingStallRequirements[i][6]  },
                    { craftingStallRequirements[i][7],  craftingStallRequirements[i][8]  },
                    { craftingStallRequirements[i][9],  craftingStallRequirements[i][10] },
                    { craftingStallRequirements[i][11], craftingStallRequirements[i][12] },
                })
            then
                return synergyResult(player, npc, craftingStall)
            end
        end
    end


    ----------------------------------------------------------------------------------------------
    -- Sky Synergy
    ----------------------------------------------------------------------------------------------
    for _, upgradeInfo in pairs(skyUpgrades) do
        if cexi.util.tradeHasExactly(trade, {
            { upgradeInfo.itemID,       1 },
            { upgradeInfo.scrapID,     99 },
            { xi.item.AETHER_FRAGMENT, 10 },
        }) then
            if cexi.util.augment.hasAugments(player, upgradeInfo.itemID, upgradeInfo.augments) then
                cexi.wf(player, fmt("[SYNERGY]{}", upgradeInfo.name), fmt("{} is the first player to obtain {}!", player:getName(), upgradeInfo.name))
                return synergyResult(player, npc, upgradeInfo.resultID)
            end
        end
    end

    ----------------------------------------------------------------------------------------------
    -- Sky 2.0 Synergy
    ----------------------------------------------------------------------------------------------
    for _, upgradeInfo in pairs(sky2Upgrades) do
        if cexi.util.tradeHasExactly(trade, {
            { upgradeInfo.itemID,       1 },
            { upgradeInfo.brokenID,     1 },
            { upgradeInfo.materialID,   5 },
            { xi.item.AETHER_FRAGMENT, 25 },
        }) then
            if cexi.util.augment.hasAugments(player, upgradeInfo.itemID, upgradeInfo.augments) then
                cexi.wf(player, fmt("[SYNERGY]{}", upgradeInfo.name), fmt("{} is the first player to obtain {}!", player:getName(), upgradeInfo.name))
                return synergyResult(player, npc, upgradeInfo.resultID)
            end
        end
    end

    ----------------------------------------------------------------------------------------------
    -- Augmented Items
    ----------------------------------------------------------------------------------------------
    for itemID, upgradeInfo in pairs(synergyUpgrade) do
        if cexi.util.tradeHasExactly(trade, upgradeInfo.mats) then
            if cexi.util.augment.hasAugments(player, upgradeInfo.item, upgradeInfo.augs) then
                cexi.wf(player, fmt("[SYNERGY]{}", upgradeInfo.name), fmt("{} is the first player to obtain {}!", upgradeInfo.name, player:getName()))
                return synergyResult(player, npc, itemID)
            end
        end
    end

    ----------------------------------------------------------------------------------------------
    -- Recipes
    ----------------------------------------------------------------------------------------------
    for itemID, materials in pairs(recipes) do
        if npcUtil.tradeHasExactly(trade, materials) then
            if announce[itemID] ~= nil then
                cexi.wf(player, fmt("[SYNERGY]{}", announce[itemID]), fmt("{} is the first player to obtain {}!", player:getName(), announce[itemID]))
            end

            return synergyResult(player, npc, itemID)
        end
    end

    ----------------------------------------------------------------------------------------------
    -- Augments
    ----------------------------------------------------------------------------------------------
    if
        player:getFreeSlotsCount() == 0 or
        not player:hasTitle(xi.title.KIRIN_CAPTIVATOR)
    then
        player:printToPlayer( "You must defeat Kirin and/or have one free item slot.", xi.msg.channel.SYSTEM_3)
        return
    end

    local randomC = math.random(1, 100)

    local itemId   = 0 -- Gear
    local item1    = 0
    local item2    = 0
    local item3    = 0
    local item4    = 0
    local aug0     = 0 -- Augments from table randomly selected
    local pow0     = 0 -- Power randomly selected
    local powerMin = 0
    local powerMax = 0
    local type     = resultType.NONE -- Type of augment (KIRIN = 3, HIGH_Q = 2, REGULAR = 1, NONE = 0)

    for i = 1, 106 do
        itemId   = validTrades[i][1]
        item1    = validTrades[i][2]
        aug0     = validTrades[i][3]
        powerMin = validTrades[i][4]
        powerMax = validTrades[i][5]

        -- 2-item trades
        if i <= 96 then
            if npcUtil.tradeHasExactly(trade, {itemId, item1}) then
                type = validTrades[i][6]

                if powerMax > 0 then
                    pow0 = math.random(powerMin, powerMax)
                else
                    pow0 = 0
                end

                break
            end

        else
            -- 4-item trades
            item2 = validTrades[i][7]
            item3 = validTrades[i][8]

            if i <= 102 then
                if npcUtil.tradeHasExactly(trade, {itemId, item1, item2, item3}) then
                    type = validTrades[i][6]

                    if fomorWeapons[itemId] then
                        itemId = fomorWeapons[itemId]
                    end

                    if powerMax > 0 then
                        pow0 = math.random(powerMin, powerMax)
                    else
                        pow0 = 0
                    end

                    break
                end

            -- 5-item trades
            else
                item4 = validTrades[i][9]

                if npcUtil.tradeHasExactly(trade, {itemId, item1, item2, item3, item4}) then
                    type = validTrades[i][6]

                    if fomorWeapons[itemId] then
                        itemId = fomorWeapons[itemId]
                    end

                    if powerMax > 0 then
                        pow0 = math.random(powerMin, powerMax)
                    else
                        pow0 = 0
                    end

                    break
                end
            end
        end
    end

    -- FallBack
    if type > resultType.NONE then
        -- Store roll amount for next augment system.
        local count = player:getCharVar("[Furnace]Count")
        local name  = player:getName()
        local total = count + 1

        player:setCharVar("[Furnace]Count", total)

        if not cexi.hasSetting(player, cexi.setting.SKIP_FURNACE_RP) then
            if souls == 0 then
                player:printToPlayer("feels unwell. The faint echos of evil laughter can be heard in the distance ...", xi.msg.channel.EMOTION)
                player:printToPlayer(string.format("The furnace reaps away a piece of %s's soul!", name), xi.msg.channel.SYSTEM_3)
            else
                player:printToPlayer(string.format("%s has given up %i pieces of their soul to the furnace.", name, total), xi.msg.channel.SYSTEM_3)
            end
        end

        -- Roll for regular or random augments.
        if randomC <= 70 then
            if type == resultType.REGULAR then
                handleAugmentedItemCreation(player, itemId, aug0, pow0)
            elseif type == resultType.HIGH_Q then
                handleHqItemCreation(player, itemId, aug0, pow0)
            elseif type == resultType.KIRIN then
                handleKirinItemCreation(player, itemId, aug0, pow0)
            elseif type == resultType.SPECIAL then
                handleSpecialAugmentedItemCreation(player, itemId, aug0, pow0)
            end
        else
            handleRandomAugment(player, itemId, aug0, pow0)
        end
    else
        player:printToPlayer( "This item combination is incorrect.", xi.msg.channel.SYSTEM_3 )
    end
end

for _, zoneName in pairs(synergyZones) do
    local path = fmt("xi.zones.{}.npcs.Synergy_Furnace", zoneName)

    xi.module.ensureTable(path)

    cexi.util.reloadOverride(m, path .. ".onTrigger", onTrigger)
    cexi.util.reloadOverride(m, path .. ".onTrade", onTrade)
end

return m
