-----------------------------------
--  NPC: Synergy_Engineer
-----------------------------------
require('modules/module_utils')
-----------------------------------
local m = Module:new('npc_synergy_engineer')

local synergyZones =
{
    'Bastok_Markets',
    'Bastok_Mines',
    'Port_Bastok',
    'Northern_San_dOria',
    'Upper_Jeuno',
    'Lower_Jeuno',
    'Port_Jeuno',
    'Tavnazian_Safehold',
    'Aht_Urhgan_Whitegate',
}

local scraps =
{
    [1404] = 3275, -- Seal of Genbu Scrap
    [1407] = 3276, -- Seal of Suzaku Scrap
    [1405] = 3277, -- Seal of Seiryu Scrap
    [1406] = 3278, -- Seal of Byakko Scrap

    -- Neptunal Tatter
    [1339] = 3279,
    [1340] = 3279,
    [1341] = 3279,
    [1342] = 3279,
    [1343] = 3279,

    -- Martial Tatter
    [1329] = 3280,
    [1330] = 3280,
    [1331] = 3280,
    [1332] = 3280,
    [1333] = 3280,

    -- Earthen Tatter
    [1319] = 3281,
    [1320] = 3281,
    [1321] = 3281,
    [1322] = 3281,
    [1323] = 3281,

    -- Dryadic Tatter
    [1314] = 3282,
    [1315] = 3282,
    [1316] = 3282,
    [1317] = 3282,
    [1318] = 3282,

    -- Aquarian Tatter
    [1324] = 3283,
    [1325] = 3283,
    [1326] = 3283,
    [1327] = 3283,
    [1328] = 3283,

    -- Wyrmal Tatter
    [1334] = 3284,
    [1335] = 3284,
    [1336] = 3284,
    [1337] = 3284,
    [1338] = 3284,

    -- Phantasmal Tatter
    [2429] = 3285,
    [2430] = 3285,
    [2431] = 3285,
    [2432] = 3285,
    [2433] = 3285,

    -- Hadean Tatter
    [2434] = 3286,
    [2435] = 3286,
    [2436] = 3286,
    [2437] = 3286,
    [2438] = 3286,
}

local function onTrade(player, npc, trade)
    if player:getFreeSlotsCount() >= 1 then
        for seal, scrap in pairs(scraps) do
            if npcUtil.tradeHasExactly(trade, { seal }) then
                local random   = math.random(1, 100)
                local quantity = 3

                if random > 85 then
                    quantity = 12
                elseif random > 65 then
                    quantity = 9
                elseif random > 35 then
                    quantity = 6
                end

                player:tradeComplete()
                cexi.util.dialog(player, { 'Here you go, use this tatter in the furnace.' }, npc:getPacketName(), { npc = npc })
                player:addItem(scrap, quantity)
                player:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED + 9, scrap, quantity)

                return
            end
        end
    end

    cexi.util.dialog.player(player, { 'What are you, stupid? That isn\'t what I asked for. Check that your pockets aren\'t full either.' }, npc:getPacketName(), { npc = npc })
end

local function onTrigger(player, npc)
    cexi.util.dialog(player, {
        'So I hear you need some Scaps or Tatters?',
        '  Trade me the Seals of Genbu, Byakko, Suzaku or Seiryu, in return I will give you the Scraps.',
        'You can also trade me the Abjuration in return I will give you the Tatters.',
        ' I\'ll only accept them one by one, though. Tough luck.',
        'Take your time, I will be here all week.',
    }, npc:getPacketName(), { npc = npc })
end

for _, zoneName in pairs(synergyZones) do
    local path = fmt('xi.zones.{}.npcs.Synergy_Engineer', zoneName)

    xi.module.ensureTable(path)

    cexi.util.reloadOverride(m, path .. '.onTrigger', onTrigger)
    cexi.util.reloadOverride(m, path .. '.onTrade', onTrade)
end

return m
