-----------------------------------
-- SMN Cloister Warps
-----------------------------------
-- Allow Summoners to warp to the cloister for a nominal fee after completing mini-trials
-- Mini-forks are used up after completing the level 20 quests, punishing players for completing them
-----------------------------------
require("modules/module_utils")
require("scripts/globals/quests")
-----------------------------------
local m = Module:new("smn_cloister_warps")

local trials =
{
    {
        npc   = { "Ferrol", "Port_Bastok" },
        quest = { xi.questLog.BASTOK, xi.quest.id.bastok.TRIAL_SIZE_TRIAL_BY_EARTH },
        warp  = { "Cloister of Tremors", { -540.269, 1.396, -509.800, 192, 209 } },
    },
    {
        npc   = { "Castilchat", "Northern_San_dOria" },
        quest = { xi.questLog.SANDORIA, xi.quest.id.sandoria.TRIAL_SIZE_TRIAL_BY_ICE },
        warp  = { "Cloister of Frost", { 550.403, 0.006, 584.820, 217, 203 } },
    },
    {
        npc   = { "Lacia", "Mhaura" },
        quest = { xi.questLog.OTHER_AREAS, xi.quest.id.otherAreas.TRIAL_SIZE_TRIAL_BY_LIGHTNING },
        warp  = { "Cloister of Storms", { 540.853, -13.329, 511.298, 82, 202 } },
    },
    {
        npc   = { "Dodmos", "Kazham" },
        quest = { xi.questLog.OUTLANDS, xi.quest.id.outlands.TRIAL_SIZE_TRIAL_BY_FIRE },
        warp  = { "Cloister of Flames", { -716.461, 0.407, -606.661, 168, 207 } },
    },
    {
        npc   = { "Rahi_Fohlatti", "Rabao" },
        quest = { xi.questLog.OUTLANDS, xi.quest.id.outlands.TRIAL_SIZE_TRIAL_BY_WIND },
        warp  = { "Cloister of Gales", { -374.919, 0.628, -386.774, 226, 201 } },
    },
    {
        npc   = { "Verctissa", "Norg" },
        quest = { xi.questLog.OUTLANDS, xi.quest.id.outlands.TRIAL_SIZE_TRIAL_BY_WATER },
        warp  = { "Cloister of Tides", {  570.294, 36.757, 546.895, 167, 211 } },
    },
}

for _, trial in pairs(trials) do
    m:addOverride(string.format("xi.zones.%s.npcs.%s.onTrade", trial.npc[2], trial.npc[1]), function(player, npc, trade)
        if
            player:getMainJob() == xi.job.SMN and
            player:hasCompletedQuest(trial.quest[1], trial.quest[2]) and
            npcUtil.tradeHasExactly(trade, { { "gil", 100 } })
        then
            npc:facePlayer(player, true)

            player:customMenu({
                title   = string.format("Travel to %s?", trial.warp[1]),
                options =
                {
                    {
                        "Not yet",
                        function()
                        end,
                    },
                    {
                        "I'm ready",
                        function()
                            player:tradeComplete()
                            player:setPos(unpack(trial.warp[2]))
                        end,
                    },
                },
            })
        end

        super(player, npc, trade)
    end)
end

return m
