-----------------------------------
-- Area: Uleguerand Range
-- NPC: Buffalostalker Dodzbraz
-- Type: Quest NPC
-- Quest: Bombs Away! (96)
-- !pos -380.171 -24.89 -180.797 5
-- !additem 1667 (Cluster Core)
-- !additem 5267 (Shumeyo Salt)
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
-----------------------------------

local m = Module:new("shumeyo_salt")

m:addOverride("xi.zones.Uleguerand_Range.npcs.Buffalostalker_Dodzbraz.onTrigger", function(player, npc)
    player:startEvent(6, 1667) -- CLUSTER_CORE
end)

m:addOverride("xi.zones.Uleguerand_Range.npcs.Buffalostalker_Dodzbraz.onTrade", function(player, npc, trade)
    if npcUtil.tradeHas(trade, { { 1667, 2 } }) then -- Cluster Core x2
        player:startEvent(8, 1667)
    else
        player:startEvent(7)
    end
end)

m:addOverride("xi.zones.Uleguerand_Range.npcs.Buffalostalker_Dodzbraz.onEventFinish", function(player, csid, option)
    if csid == 8 then
        npcUtil.giveItem(player, 5267) -- Chunk of Shumeyo Salt
        player:confirmTrade()
    end
end)

return m
