-----------------------------------
-- CatsEyeXI
-- Shen QM pop fix
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
-----------------------------------
local m = Module:new("shen_qm_fix")

m:addOverride("xi.zones.Bibiki_Bay.npcs.qm_shen.onTrade", function(player, npc, trade)
    local shenId = player:getZone():queryEntitiesByName('Shen')[1]:getID()
    local zone = player:getZone()
    local entityList = zone:queryEntitiesByName('qm_shen')
    if
        npcUtil.tradeHasExactly(trade, xi.item.SHRIMP_LANTERN)
    then
        player:confirmTrade()
        SpawnMob(shenId):updateClaim(player)
        entityList[1]:setStatus(xi.status.DISAPPEAR)
    end
end)

m:addOverride("xi.zones.Bibiki_Bay.mobs.Shen.onMobDespawn", function(mob)
    local zone = mob:getZone()
    local entityList = zone:queryEntitiesByName('qm_shen')

    entityList[1]:setStatus(xi.status.NORMAL)
end)

return m
