-----------------------------------
-- Area: Aht Urhgan Whitegate
--  NPC: Sorrowful Sage
-- Type: Assault Mission Giver
-- !pos 134.096 0.161 -30.401 50
-----------------------------------
local ID = require("scripts/zones/Aht_Urhgan_Whitegate/IDs")
require("scripts/globals/besieged")
require("scripts/globals/missions")
require("modules/module_utils")
-----------------------------------

local m = Module:new("salvage_sorrowful_sage")

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Sorrowful_Sage.onTrigger", function(player, npc)
    local rank = xi.besieged.getMercenaryRank(player)
    local haveimperialIDtag
    local tokens = 3
    local floorProgress = player:getCharVar("NyzulFloorProgress")

    if player:hasKeyItem(xi.ki.IMPERIAL_ARMY_ID_TAG) then
        haveimperialIDtag = 1
    else
        haveimperialIDtag = 0
    end

    if rank > 0 then
        player:startEvent(278, rank, haveimperialIDtag, tokens, player:getCurrentAssault(), floorProgress)
    else
        player:startEvent(284) -- no rank
    end
end)

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Sorrowful_Sage.onTrade", function(player, npc, trade)
    if csid == 278 then
        local categorytype = bit.band(option, 0x0F)
        if categorytype == 3 then
            -- low grade item
            local item = bit.rshift(option, 16)
        elseif categorytype == 4 then
            -- medium grade item
            local item = bit.rshift(option, 16)
        elseif categorytype == 5 then
            -- high grade item
            local item = bit.rshift(option, 16)
        end
    end
end)

return m
