-----------------------------------
-- Ghanraam (K-10) Aht Urhgan Whitegate
-- !pos 107.113 -6.000 -51.281 60
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("salvage_gear")

local material =
{
    orichalcumIngots = {  747, 6 },
    wootzIngots      = {  686, 6 },
    bloodwoodLumber  = {  730, 6 },
    wamouraCloth     = { 2289, 6 },
    maridLeather     = { 2152, 6 },
}

local armor =
{
    [16084] = { 16085, 16086, 16087, material.orichalcumIngots },
    [14546] = { 14547, 14548, 14549, material.wootzIngots      },
    [14961] = { 14962, 14963, 14964, material.bloodwoodLumber  },
    [15625] = { 15626, 15627, 15628, material.wamouraCloth     },
    [15711] = { 15712, 15713, 15714, material.maridLeather     },
    [16088] = { 16089, 16090, 16091, material.orichalcumIngots },
    [14550] = { 14551, 14552, 14553, material.wootzIngots      },
    [14965] = { 14966, 14967, 14968, material.bloodwoodLumber  },
    [15629] = { 15630, 15631, 15632, material.wamouraCloth     },
    [15715] = { 15716, 15717, 15718, material.maridLeather     },
    [16092] = { 16093, 16094, 16095, material.orichalcumIngots },
    [14554] = { 14555, 14556, 14557, material.wootzIngots      },
    [14969] = { 14970, 14971, 14972, material.bloodwoodLumber  },
    [15633] = { 15634, 15635, 15636, material.wamouraCloth     },
    [15719] = { 15720, 15721, 15722, material.maridLeather     },
    [16096] = { 16097, 16098, 16099, material.orichalcumIngots },
    [14558] = { 14559, 14560, 14561, material.wootzIngots      },
    [14973] = { 14974, 14975, 14976, material.bloodwoodLumber  },
    [15637] = { 15638, 15639, 15640, material.wamouraCloth     },
    [15723] = { 15724, 15725, 15726, material.maridLeather     },
    [16100] = { 16101, 16102, 16103, material.orichalcumIngots },
    [14562] = { 14563, 14564, 14565, material.wootzIngots      },
    [14977] = { 14978, 14979, 14980, material.bloodwoodLumber  },
    [15641] = { 15642, 15643, 15644, material.wamouraCloth     },
    [15727] = { 15728, 15729, 15730, material.maridLeather     },
}

-- Stored in bitmask - Do not change order
local weapons =
{
    { id = 18492, name = "Sturdy Axe"     }, -- WAR
    { id = 18753, name = "Burning Fists"  }, -- MNK
    { id = 18851, name = "Werebuster"     }, -- WHM
    { id = 18589, name = "Mage's Staff"   }, -- BLM
    { id = 17742, name = "Vorpal Sword"   }, -- RDM
    { id = 18003, name = "Swordbreaker"   }, -- THF
    { id = 17744, name = "Brave Blade"    }, -- PLD
    { id = 18944, name = "Death Sickle"   }, -- DRK
    { id = 17956, name = "Double Axe"     }, -- BST
    { id = 18034, name = "Dancing Dagger" }, -- BRD
    { id = 18719, name = "Killer Bow"     }, -- RNG
    { id = 18443, name = "Wind Slicer"    }, -- SAM
    { id = 18426, name = "Sasuke Katana"  }, -- NIN
    { id = 18120, name = "Radiant Lance"  }, -- DRG
    { id = 18590, name = "Scepter Staff"  }, -- SMN
    { id = 17743, name = "Wightslayer"    }, -- BLU
    { id = 18720, name = "Quicksilver"    }, -- COR
    { id = 18754, name = "Inferno Claws"  }, -- PUP
    { id = 19102, name = "Main Gauche"    }, -- DNC
    { id = 18592, name = "Elder Staff"    }, -- SCH
}

-- Each armor requires 10 Imperial Gold Pieces
for index, _ in pairs(armor) do
    table.insert(armor[index], { 2187, 10 })
end

local path = "xi.zones.Aht_Urhgan_Whitegate.npcs.Ghanraam"

cexi.util.reloadOverride(m, path .. ".onTrade", function(player, npc, trade)
    for result, required in pairs(armor) do
        if npcUtil.tradeHasExactly(trade, required) then
            npc:facePlayer(player, true)

            if npcUtil.giveItem(player, result) then
                npc:ceEmote(player, xi.emote.BOW, xi.emoteMode.MOTION)
                player:printToPlayer("Ghanraam : As promised, here is your finished piece.", xi.msg.channel.NS_SAY)
                player:tradeComplete()
            else
                npc:ceEmote(player, xi.emote.NO, xi.emoteMode.MOTION)
                player:printToPlayer("Ghanraam : Please return after sorting your inventory", xi.msg.channel.NS_SAY)
                player:tradeRelease()
            end

            return
        end
    end

    -- Storing weapons requires one Imperial Bronze Piece
    for index, itemInfo in pairs(weapons) do
        if npcUtil.tradeHasExactly(trade, { { itemInfo.id, 1 }, { xi.item.IMPERIAL_BRONZE_PIECE, 1 } }) then
            local current = player:getCharVar("[GHANRAAM]VIGIL_WEAPONS")

            current = utils.mask.setBit(current, index, true)

            player:setCharVar("[GHANRAAM]VIGIL_WEAPONS", current)
            player:tradeComplete()

            cexi.util.dialog(player, {
                fmt("I've stored your {}.\n Please come back and collect it whenever you're ready.", itemInfo.name),
            }, npc:getPacketName(), { npc = npc })

            return
        end
    end
end)

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function retrieveItem(player, npc, itemInfo)
    if npcUtil.giveItem(player, itemInfo[2]) then
        local current = player:getCharVar("[GHANRAAM]VIGIL_WEAPONS")
        current = utils.mask.setBit(current, itemInfo[3], false)
        player:setCharVar("[GHANRAAM]VIGIL_WEAPONS", current)
    end
end

cexi.util.reloadOverride(m, path .. ".onTrigger", function(player, npc)
    local current = player:getCharVar("[GHANRAAM]VIGIL_WEAPONS")

    if current == 0 then
        return
    end

    -- Weapons can be retrieved if at least one is stored
    local storedList = {}

    for index, itemInfo in pairs(weapons) do
        if utils.mask.getBit(current, index) then
            table.insert(storedList, { itemInfo.name, itemInfo.id, index })
        end
    end

    cexi.util.simpleMenu(player, npc, storedList, retrieveItem, "Retrieve Weapon:")
end)

return m
