-----------------------------------
-- Sagheera +1 upgrades for Relic GEO, RUN
-----------------------------------
require("modules/module_utils")
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("sagheera_relic_geo_run")

local trades =
{
    -- Bagua Galero +1
    [26665] =
    {
        base = 26664,
        mats = { { 1449, 30 }, { 1705, 1 }, { 4246, 1 } }, -- T.Whiteshell x30, Kunwu Sheet x1, Cantarella x1
    },

    -- Bagua Tunic +1
    [26841] =
    {
        base = 26840,
        mats = { { 1449, 30 }, { 2424, 1 }, { 742, 1 } }, -- T.Whiteshell x30, Incomb. Wool x1, P. Brass Ingot x1
    },

    -- Bagua Mitaines +1
    [27017] =
    {
        base = 27016,
        mats = { { 1449, 30 }, { 2537, 1 }, { 2751, 1 } }, -- T.Whiteshell x30, Cilice x1, Amph. Leather x1
    },

    -- Bagua Pants +1
    [27193] =
    {
        base = 27192,
        mats = { { 1449, 30 }, { 2705, 1 }, { 669, 1 } }, -- T.Whiteshell x30, Foulard x1, Mlbd. Sheet x1
    },

    -- Bagua Sandals +1
    [27369] =
    {
        base = 27368,
        mats = { { 1449, 30 }, { 2703, 1 }, { 2535, 1 } }, -- T.Whiteshell x30, Khrom. Leather x1, Jacaranda Lbr. x1
    },

    -- Futhark Bandeau +1
    [26667] =
    {
        base = 26666,
        mats = { { 1452, 30 }, { 743, 1 }, { 4246, 1 } }, -- O. Bronzepiece x30, Ph. Gold Ingot x1, Cantarella x1
    },

    -- Futhark Coat +1
    [26843] =
    {
        base = 26842,
        mats = { { 1452, 30 }, { 1285, 1 }, { 742, 1 } }, -- O. Bronzepiece x30, Luminous Core x1, P. Brass Ingot x1
    },

    -- Futhark Mitons +1
    [27019] =
    {
        base = 27018,
        mats = { { 1452, 30 }, { 735, 1 }, { 2751, 1 } }, -- O. Bronzepiece x30, Thokcha Ingot x1, Amph. Leather x1
    },

    -- Futhark Trousers +1
    [27195] =
    {
        base = 27194,
        mats = { { 1452, 30 }, { 2538, 1 }, { 669, 1 } }, -- O. Bronzepiece x30, Peiste Leather x1, Mlbd. Sheet x1
    },

    -- Futhark Boots +1
    [27371] =
    {
        base = 27370,
        mats = { { 1452, 30 }, { 875, 1 }, { 2535, 1 } }, -- O. Bronzepiece x30, Amaltheia Lth. x1, Jacaranda Lbr. x1
    },
}

-- Mats should always include base item
for k, v in pairs(trades) do
    table.insert(v.mats, v.base)
end

m:addOverride("xi.zones.Port_Jeuno.npcs.Sagheera.onTrade", function(player, npc, trade)
    if player:getCurrentMission(xi.mission.log_id.COP) < xi.mission.id.cop.GARDEN_OF_ANTIQUITY then
        return
    end

    for hq, reqs in pairs(trades) do
        if npcUtil.tradeHasExactly(trade, reqs.mats) then
            player:printToPlayer("Sagheera : Your armor restoration is complete!", xi.msg.channel.NS_SAY)
            npc:facePlayer(player, true)

            if npcUtil.giveItem(player, hq) then
                player:confirmTrade()
                player:setCharVar("AFupgradeDay", getVanaMidnight())
            end

            return
        end
    end

    super(player, npc, trade)
end)

return m
