-----------------------------------
-- Area: Lufaise Meadows
--  NPC: ??? - Amaltheia spawn
-- !pos 347.897 -10.895 264.382 24
-----------------------------------
require('scripts/globals/npc_util')
require('modules/module_utils')
-----------------------------------
local ID = zones[xi.zone.LUFAISE_MEADOWS]
-----------------------------------
local m = Module:new('qm_amaltheia')

local modulePath = 'xi.zones.Lufaise_Meadows.npcs.qm1'

xi.module.ensureTable(modulePath)

m:addOverride(modulePath .. '.onTrade', function(player, npc, trade)
    if
        npcUtil.tradeHas(trade, xi.item.RELIC_SHIELD) and
        npcUtil.popFromQM(player, npc, ID.mob.AMALTHEIA)
    then
        player:confirmTrade()
    end
end)

m:addOverride(modulePath .. '.onTrigger', function(player, npc)
    player:messageSpecial(ID.text.NOTHING_OUT_OF_ORDINARY)
end)

return m
