-----------------------------------
-- Area: Western Altepa Desert
--  NPC: ??? (Beastmen Treasure qm8/chest5)
-- !pos -223.055 -0.085 -672.207 125
-----------------------------------
require("scripts/globals/beastmentreasure")
require("scripts/globals/npc_util")
require("modules/module_utils")
local ID = require("scripts/zones/Western_Altepa_Desert/IDs")
-----------------------------------

local m = Module:new("pop_king_vinegarroon")

m:addOverride("xi.zones.Western_Altepa_Desert.npcs.qm8.onTrade", function(player, npc, trade)
    xi.bmt.handleQmOnTrade(player, npc, trade, ID.npc.BEASTMEN_TREASURE)

    if npcUtil.tradeHasExactly(trade, 901) then -- Venomous Claw
        player:tradeComplete()
        SpawnMob(17289575):updateClaim(player) -- King Vinegarroon
    end
end)

return m
