-----------------------------------
-- Area: Lower Jeuno
--  NPC: Nantoto
--  POS: !pos -46.4248 0.0000 -49.5238 245
-- Memo: This a module over ride NPC to give temporry workarounds to disjointed missions and quests.
--       Comment all addtions to this NPC.
-----------------------------------
require("scripts/globals/utils")
require("modules/module_utils")
require('scripts/globals/npc_util')
-----------------------------------
local m = Module:new("nantoto_npc")

local rovTrusts =
{
    { mission = xi.mission.id.rov.A_LAND_AFTER_TIME, cipher = xi.item.CIPHER_OF_LIONS_ALTER_EGO_II,      spell = 1009 },
    { mission = xi.mission.id.rov.VOLTO_OSCURO,      cipher = xi.item.CIPHER_OF_ZEIDS_ALTER_EGO_II,      spell = 1010 },
    { mission = xi.mission.id.rov.CRASHING_WAVES,    cipher = xi.item.CIPHER_OF_TENZENS_ALTER_EGO_II,    spell = 1014 },
    { mission = xi.mission.id.rov.EVER_FORWARD,      cipher = xi.item.CIPHER_OF_NASHMEIRAS_ALTER_EGO_II, spell = 1012 },
}

xi.module.ensureTable("xi.zones.Lower_Jeuno.npcs.Nantoto")

m:addOverride("xi.zones.Lower_Jeuno.npcs.Nantoto.onTrigger", function(player, npc)
    local playerNation = player:getNation()

    if not (player:isCrystalWarrior() or player:isClassicMode()) then
        for _, rovTrust in pairs(rovTrusts) do
            if
                player:hasCompletedMission(xi.mission.log_id.ROV, rovTrust.mission) and
                not player:hasItem(rovTrust.cipher) and
                not player:hasSpell(rovTrust.spell)
            then
                if npcUtil.giveItem(player, rovTrust.cipher) then
                    cexi.util.dialog(player, { "Hello there, it seems like you were meant to have this!" }, npc:getPacketName(), { npc = npc } )
                end
            end
        end
    end

    -- Work around to give players CIPHER_OF_SEMIHS_ALTER_EGO.
    if player:getCurrentMission(xi.mission.log_id.playerNation) == 23 and player:getNation() == 0 then
        print("Broken Mission Detected")
        player:setMissionStatus(0, 6)
        player:printToPlayer("Sending you to King Ranperres Tomb. Click the Heavy Stone Door to progress...")
        player:timer(3500, function(playerArg)
            playerArg:setPos(-35.699, 7.50, 19.997, 131, 190)
        end)

        return
    end

    player:printToPlayer("Nantoto: Hello, my name is Nantoto!", xi.msg.channel.NS_SAY)
    player:timer(1000, function(playerArg)
        playerArg:printToPlayer("Nantoto: Come see me if you any need help.", xi.msg.channel.NS_SAY)
    end)
end)

return m
