-----------------------------------
-- Area: Caedarva Mire
--  NPC: Nahshib
-- Type: Assault
-- !pos -274.334 -9.287 -64.255 79
-- Notes: Return toua mission 30 entry item when appropriate
-----------------------------------
require('modules/module_utils')
-----------------------------------
local ID = zones[xi.zone.CAEDARVA_MIRE]
-----------------------------------
local m = Module:new('nahshib_npc')

local modulePath = 'xi.zones.Caedarva_Mire.npcs.Nahshib'

xi.module.ensureTable('xi.zone.Caedarva_Mire.npcs.Nahshib')

m:addOverride(modulePath .. '.onTrigger', function(player, npc)
    local toauMission = player:getCurrentMission(xi.mission.log_id.TOAU)

    if toauMission == xi.mission.id.toau.SHADES_OF_VENGEANCE then
        if not player:hasKeyItem(xi.ki.PERIQIA_ASSAULT_AREA_ENTRY_PERMIT) then
            player:startEvent(22)
            return
        end
    end
    -- ASSAULT
    if toauMission >= xi.mission.id.toau.PRESIDENT_SALAHEEM then
        local IPpoint = player:getCurrency('imperial_standing')
        if
            player:hasKeyItem(xi.ki.PERIQIA_ASSAULT_ORDERS) and
            not player:hasKeyItem(xi.ki.ASSAULT_ARMBAND)
        then
            player:startEvent(148, 50, IPpoint)
        else
            player:startEvent(7)
            -- player:delKeyItem(xi.ki.ASSAULT_ARMBAND)
        end

    -- DEFAULT DIALOG
    else
        player:startEvent(4)
    end
end)

return m
