require('modules/module_utils')
require('scripts/globals/npc_util')
-----------------------------------

local m = Module:new('mythic_weapon')

m:addOverride('xi.zones.Nashmau.npcs.Paparoon.onTrade', function(player, npc, trade)
    local alexandrite     = 2488
    local alexCount       = trade:getItemCount()
    local storedAlex      = player:getCharVar('Paparoon_AlexStored')
    local exchangeVoucher = player:getCharVar('MythicWeaponExchange')
    local hasCaptain      = player:hasKeyItem(xi.ki.CAPTAIN_WILDCAT_BADGE)

    -- check to see if player already has alex stored, if he does we'll add to his total
    if
        storedAlex and
        npcUtil.tradeHasOnly(trade, alexandrite)
    then
        local newStoredAlex = storedAlex + alexCount
        player:setCharVar('Paparoon_AlexStored', newStoredAlex)

        -- exchange alexandrite for alex if we're at 30000 --
        if
            exchangeVoucher == 1 and
            newStoredAlex < 10000
        then
            player:tradeComplete()
            player:setCharVar('Paparoon_AlexStored', (newStoredAlex - 10000))
            player:setCharVar('PendingMythic', 1)
            player:printToPlayer('Paparoon: Aight dawg! A deal\'s a deal! Head back to that creepy ass Tombstone in Caedarva Mire and trade', xi.msg.channel.NS_SAY)
            player:printToPlayer('Paparoon: the corresponding base mythic weapon to get your new bling.', xi.msg.channel.NS_SAY)
        elseif
            newStoredAlex >= 30000 and
            hasCaptain
        then
            player:tradeComplete()
            player:setCharVar('Paparoon_AlexStored', (newStoredAlex - 30000))
            player:printToPlayer('Paparoon: 1...2...3...30,0000! That\'s unreal yo!', xi.msg.channel.NS_SAY)
            npcUtil.giveItem(player, 3443)
        elseif
            newStoredAlex >= 30000 and
            not hasCaptain
        then
            player:tradeComplete()
            player:printToPlayer('Paparoon: You still not a captain?! Come back when you are!', xi.msg.channel.NS_SAY)
            return
        elseif not storedAlex then
            player:setCharVar('Paparoon_AlexStored', alexCount)
            player:printToPlayer(string.format('Paparoon: I guess this is better than nothin\'... You have %i alexandrite stored!', storedAlex), xi.msg.channel.NS_SAY)
            player:tradeComplete()
            return
        else
            player:printToPlayer(string.format('Paparoon: That makes a total of %i alexandrite stored!', newStoredAlex), xi.msg.channel.NS_SAY)
            player:tradeComplete()
            return
        end
    end
end)

m:addOverride('xi.zones.Nashmau.npcs.Paparoon.onTrigger', function(player, npc)
    local storedAlex      = player:getCharVar('Paparoon_AlexStored')
    local hasCaptain      = player:hasKeyItem(xi.ki.CAPTAIN_WILDCAT_BADGE)
    local exchangeVoucher = player:getCharVar('MythicWeaponExchange')

    -- tell the player how many alex they have stored, if any
    if
        exchangeVoucher == 2 and
        storedAlex < 10000
    then
        player:printToPlayer('Paparoon: Yo! What\'s this?! An exchange voucher? Deposit 10,000 alexandrite and I\'ll grant your new bling!', xi.msg.channel.NS_SAY)
        player:printToPlayer(string.format('Paparoon: You have %i alexandrite stored!', storedAlex), xi.msg.channel.NS_SAY)
        return
    elseif
        exchangeVoucher == 2 and
        storedAlex >= 10000
    then
        player:setCharVar('Paparoon_AlexStored', (storedAlex - 10000))
        player:setCharVar('PendingMythic', 1)
        player:printToPlayer('Paparoon: Aight dawg! A deal\'s a deal! Head back to that creepy Tombstone in Caedarva Mire and trade', xi.msg.channel.NS_SAY)
        player:printToPlayer('Paparoon: the corresponding base mythic weapon to get your new bling.', xi.msg.channel.NS_SAY)
        return
    elseif storedAlex == nil then
        player:printToPlayer('Paparoon: Do I know you?! Back off yo!', xi.msg.channel.NS_SAY)
    elseif storedAlex < 30000 then
        player:printToPlayer(string.format('Paparoon: How many times are you going to ask?? You have %i alexandrite stored!', storedAlex), xi.msg.channel.NS_SAY)
    elseif
        storedAlex >= 30000 and
        not hasCaptain
    then
        player:printToPlayer('Paparoon: You still not a captain?! Come back when you are!', xi.msg.channel.NS_SAY)
    elseif
        storedAlex >= 30000 and
        hasCaptain
    then
        player:setCharVar('Paparoon_AlexStored', (storedAlex - 30000))
        player:printToPlayer('Paparoon: 1...2...3...30,0000! That\'s unreal yo!', xi.msg.channel.NS_SAY)
        npcUtil.giveItem(player, 3443)
    end
end)

m:addOverride('xi.zones.Caedarva_Mire.npcs.Seaprinces_Tombstone.onTrade', function(player, npc, trade)
    -- !pos  -433 7 -586 79
    local t4trophies         = (npcUtil.tradeHas(trade, xi.item.TINNINS_FANG) and
                                npcUtil.tradeHas(trade, xi.item.SARAMEYAS_HIDE) and
                                npcUtil.tradeHas(trade, xi.item.TYGERS_TAIL)) or
                                npcUtil.tradeHas(trade, xi.item.PANDEMONIUM_KEY) -- Pandemonium key is purchased by trading the three previous items to Ryo and spending zeni to buy this pop item
    local gurfurlursHelmet   = npcUtil.tradeHas(trade, 2356)
    local medusasArmlet      = npcUtil.tradeHas(trade, 2357)
    local jajasChestplate    = npcUtil.tradeHas(trade, 2355)
    local mythosToken        = npcUtil.tradeHas(trade, 28918)
    local imperialGoldPieces = trade:hasItemQty(2187, 99)
    local catsEye            = npcUtil.tradeHas(trade, 3443)
    local titleCheck         = player:hasTitle(xi.title.CERBERUS_MUZZLER) and player:hasTitle(xi.title.HYDRA_HEADHUNTER) and
                               player:hasTitle(xi.title.KHIMAIRA_CARVER) and player:hasTitle(xi.title.GORGONSTONE_SUNDERER) and
                               player:hasTitle(xi.title.TROLL_SUBJUGATOR) and player:hasTitle(xi.title.SHINING_SCALE_RIFLER)
    local pendingMythic      = player:getCharVar('PendingMythic')

    if
        t4trophies and
        (
            (titleCheck and
            gurfurlursHelmet and
            medusasArmlet and
            jajasChestplate)
            or -- Don't require title check or HNM drops when using mythos token.
            mythosToken
        ) and
        catsEye and
        imperialGoldPieces
    then
        -- Turn in prereqs for Mythic Redeem
        player:tradeComplete()
        player:setCharVar('PendingMythic', 1)
        player:printToPlayer('Balrahn Eidolon: I have nearly everything I need... Come back with your base weapon to complete the upgrade.', xi.msg.channel.NS_SAY)

        return
    else
        local baseBaseWeapon = 18969 -- terpsichore basic
        local baseMythic     = 18989 -- terpsichore mythic

        for i = 0, 19 do -- Loop over all possible mythic weapons
            local baseWeapon   = baseBaseWeapon + i
            local mythicWeapon = baseMythic + i

            if pendingMythic == 1 then
                -- Mythic Weapon Redeem
                if npcUtil.tradeHasExactly(trade, baseWeapon) then
                    player:setCharVar('MythicReward', mythicWeapon)
                    player:tradeComplete()
                    -- terpsichore and tupsimati are final 2 event params but first in the itemid list, so we offset the event by 2
                    player:startEvent(25, (i - 2) % 20 + 1)

                    return
                end
            else
                -- Mythic Weapon Exchange
                if npcUtil.tradeHasExactly(trade, { mythicWeapon }) then
                    player:tradeComplete()
                    player:setCharVar('MythicWeaponExchange', 1)
                    player:printToPlayer('???: Hail, adventurer! Hath thou decided to forge a new myth? I will strip this one down for the essential', xi.msg.channel.NS_SAY)
                    player:printToPlayer('???: materials required to forge the new one, but you must seek a new base weapon from Nonoroon, and receive further instruction.', xi.msg.channel.NS_SAY)

                    return
                end
            end
        end
    end
end)

m:addOverride('xi.zones.Caedarva_Mire.npcs.Seaprinces_Tombstone.onEventFinish', function(player, csid, option)
    -- !pos  -433 7 -586 79
    local mythicReward = player:getCharVar('MythicReward')

    if csid == 25 then
        if
            mythicReward > 0 and
            npcUtil.giveItem(player, mythicReward)
        then
            if player:getCharVar('MythicWeaponExchange') == 2 then
                player:setCharVar('MythicWeaponExchange', 0)
            end

            player:setCharVar('PendingMythic', 0)
            player:setCharVar('MythicReward', 0)

            if player:isCrystalWarrior() then
                local item = GetItemByID(mythicReward)

                if item ~= nil then
                    local itemName = item:getName()
                    cexi.crystal_warrior.announcement.worldFirst(
                        player,
                        fmt("CW_MYTHIC_{}", string.upper(itemName)),
                        fmt("{} is the first Crystal Warrior to obtain {}!", player:getName(),itemName)
                    )
                end
            end
        end
    end
end)

return m
