-----------------------------------
-- Area: Aht Urhgan Whitegate
--  NPC: Nonoroon
-- Mythic Start Quest
-- !gotoid 16982132
-----------------------------------
local ID = require("scripts/zones/Aht_Urhgan_Whitegate/IDs")
require("scripts/globals/npc_util")
require("scripts/globals/quests")
require("modules/module_utils")
-----------------------------------

local m = Module:new("mythic_nonoroon")

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Nonoroon.onTrigger", function(player, npc)
    local pZeni  = player:getCurrency("zeni_point")
    local pLevel = player:getMainLvl()

    if pZeni >= 6000 and pLevel > 74 then -- Zeni Points Check and Player level check.
        player:printToPlayer("I see you have at least 6000 Zeni Points and are able to equip this weapon", xi.msg.channel.NS_SAY, "Nonoroon")
        player:printToPlayer("If you can help me out with this myth then you can have the final reward!", xi.msg.channel.NS_SAY, "Nonoroon")
        player:printToPlayer("Please make sure you are on the Job you wish to continue this path!", xi.msg.channel.NS_SAY, "Nonoroon")
        player:printToPlayer("When you are ready Trade me 5 Imperial Gold Pieces and on the correct JOB!", xi.msg.channel.NS_SAY, "Nonoroon")
    else
        player:printToPlayer("You are not worthy come back when you are ready!", xi.msg.channel.NS_SAY, "Nonoroon")
    end
end)

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Nonoroon.onTrade", function(player, npc, trade)
    local pZeni  = player:getCurrency("zeni_point")
    local pLevel = player:getMainLvl()
    local baseWeapon = 18970 + player:getMainJob()

    if player:getMainJob() == xi.job.GEO or player:getMainJob() == xi.job.RUN then
        player:printToPlayer("Bro, that job doesn't get a mythic!", xi.msg.channel.NS_SAY, "Nonoroon")
        return
    end

    if pZeni >= 6000 and pLevel > 74 and npcUtil.tradeHasExactly(trade, {{2187, 5}}) then
        if player:getMainJob() == xi.job.DNC then
            baseWeapon = 18969
        end

        player:tradeComplete()
        player:delCurrency("zeni_point", 6000)
        player:printToPlayer("Yooo man, here's your new base weapon. Go see that homie paparoon for the next phase!", xi.msg.channel.NS_SAY, "Nonoroon")
        npcUtil.giveItem(player, baseWeapon)
        if player:getCharVar("MythicWeaponExchange") == 1 then
            player:setCharVar("MythicWeaponExchange", 2)
        end
    else
        player:printToPlayer("You need more Zeni Points, Incorrect level or wrong items to proceed .", xi.msg.channel.NS_SAY, "Nonoroon")
    end
end)

return m
