-----------------------------------
-- Area: Mhaura (G-8)
-- NPC: Fyi Chalmwoh
-- Allow players to obtain additional Mannequins by trading all 5 pieces
-----------------------------------
require('modules/module_utils')
-----------------------------------
local m = Module:new("npc_fyi_chalmwoh")

local path = "xi.zones.Mhaura.npcs.Fyi_Chalmwoh"

local mannequins =
{
    { "Hume M Mannequin",     256 },
    { "Hume F Mannequin",     257 },
    { "Elvaan M Mannequin",   258 },
    { "Elvaan F Mannequin",   259 },
    { "Tarutaru M Mannequin", 260 },
    { "Tarutaru F Mannequin", 261 },
    { "Mithra Mannequin",     262 },
    { "Galka Mannequin",      263 },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function getMannequinList(player)
    local tbl = {}

    for _, mannequin in pairs(mannequins) do
        if not player:hasItem(mannequin[2]) then
            table.insert(tbl, { mannequin[1], mannequin[2] })
        end
    end

    return tbl
end

local function confirmMannequin(player, npc, mannequin)
    delaySendMenu(player, {
        title   = fmt("Choose {}?", mannequin[1]),
        options =
        {
            {
                "Not yet",
                function()
                end,
            },
            {
                "I want this one",
                function()
                    if npcUtil.giveItem(player, mannequin[2]) then
                        player:setCharVar("[MANNEQUIN]TRADED", 0)
                    end
                end,
            },
        },
    })
end

m:addOverride(path .. ".onTrigger", function(player, npc)
     if player:hasCompletedQuest(xi.questLog.OTHER_AREAS, xi.quest.id.otherAreas.ITS_RAINING_MANNEQUINS) then
        if player:getCharVar("[MANNEQUIN]TRADED") > 0 then
            local tbl = getMannequinList(player)
            cexi.util.simpleMenu(player, npc, tbl, confirmMannequin, "Choose a Mannequin:")
        else
            cexi.util.dialog(player, { "Want another mannequin?\n Trade me a complete set of 5 pieces." }, npc:getPacketName(), { npc = npc })
        end

        return
    end

    super(player, npc)
end)

m:addOverride(path .. ".onTrade", function(player, npc, trade)
    if
        player:hasCompletedQuest(xi.questLog.OTHER_AREAS, xi.quest.id.otherAreas.ITS_RAINING_MANNEQUINS) and
        npcUtil.tradeHasExactly(trade, {
            xi.item.MANNEQUIN_HEAD,
            xi.item.MANNEQUIN_BODY,
            xi.item.MANNEQUIN_HANDS,
            xi.item.MANNEQUIN_LEGS,
            xi.item.MANNEQUIN_FEET,
        })
    then
        local tbl = getMannequinList(player)

        if #tbl > 0 then
            player:tradeComplete()
            player:setCharVar("[MANNEQUIN]TRADED", 1)
            cexi.util.simpleMenu(player, npc, tbl, confirmMannequin, "Choose a Mannequin:")
        end

        return
    end

    super(player, npc, trade)
end)

return m
