-----------------------------------
-- Linkshell Concierge
-- Provides Global Linkshell)
-----------------------------------
require('modules/module_utils')
local cq = require('modules/catseyexi/lua/additive_overrides/utils/custom_quest')
-----------------------------------
local m = Module:new('linkshell_concierge')

local npcZones =
{
    'Northern_San_dOria',
    'Bastok_Mines',
    'Windurst_Walls',
}

local dialog =
{
    'Linkshell Concierge : Very well, please stand by while I process your request.',
    { delay = 3000 },
    'Linkshell Concierge : Here is your global linkshell, please chat responsibly!',
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(confirmMenu)
    end)
end

local function obtainLinkshell(player, npc)
    npc:facePlayer(player)

    local linkshell = 'CatsEyeXI'

    if player:isCrystalWarrior() then
        linkshell = 'CrystalWarriors'
    end

    local confirmMenu =
    {
        title   = fmt('Receive linkshell: {}', linkshell),
        options =
        {
            {
                'No',
                function(playerArg)
                end,
            },
            {
                'Yes',
                function(playerArg)
                    if player:getFreeSlotsCount() > 0 then
                        cexi.util.dialog(player, dialog)

                        npc:timer(6000, function(npcArg)
                            playerArg:addLinkpearl(linkshell, false)
                            playerArg:messageSpecial(zones[player:getZoneID()].text.ITEM_OBTAINED, 515)

                            return
                        end)
                    else
                        player:printToPlayer('Linkshell Concierge : Please return after sorting your inventory.', xi.msg.channel.NS_SAY)

                        return
                    end
                end,
            },
        },
    }

    player:customMenu(confirmMenu)
end

for _, entry in pairs(npcZones) do
    local string = string.format('xi.zones.%s.npcs.Linkshell_Concierge', entry)

    xi.module.ensureTable(string)
    m:addOverride(string .. '.onTrigger', function(player, npc)
        obtainLinkshell(player, npc)
    end)
end

return m
