require("modules/module_utils")
-----------------------------------
local m = Module:new("kupo_shield")

local items =
{
    [xi.keyItem.WAY_OF_THE_ALCHEMIST]  = { {  1386, "Cursed Mail"      }, { 10792, "Saida Ring"     } },
    [xi.keyItem.WAY_OF_THE_BLACKSMITH] = { {  1356, "Cursed Hauberk"   }, { 19788, "Gorkhali Kukri" } },
    [xi.keyItem.WAY_OF_THE_BONEWORKER] = { {  1396, "Cursed Harness"   }, { 11058, "Hajduk Ring"    } },
    [xi.keyItem.WAY_OF_THE_CARPENTER]  = { {  1346, "Cursed Togi"      }, { 18884, "Vejovis Wand"   } },
    [xi.keyItem.WAY_OF_THE_CULINARIAN] = { {  4235, "Cursed Soup"      }, {  5930, "Sprightly Soup" } },
    [xi.keyItem.WAY_OF_THE_GOLDSMITH]  = { {  1376, "Cursed Cuirass"   }, { 11060, "Evader Earring" } },
    [xi.keyItem.WAY_OF_THE_WEAVER]     = { {  1366, "Cursed Dalmatica" }, { 11000, "Swith Cape"     } },
    [xi.keyItem.WAY_OF_THE_TANNER]     = { { 12573, "Dusk Jerkin"      }, { 10577, "Urja Trousers"  } },
}

m:addOverride("xi.zones.Bastok_Markets.npcs.Nudara.onTrade", function(player, npc, trade)
    if trade:getItemCount() > 0 and player:getCharVar("KupoShield") ~= 1 then

        for keyItem, requiredItem in pairs(items) do
            if player:hasKeyItem(keyItem) and (trade:hasItemQty(requiredItem[1][1], 1) or trade:hasItemQty(requiredItem[2][1], 1)) then
                npc:facePlayer(player, true)
                player:printToPlayer("Nudara : Very well, here you are!", xi.msg.channel.NS_SAY)

                if npcUtil.giveItem(player, 26406) then
                    player:tradeComplete()
                    player:setCharVar("KupoShield",1)
                end

                return
            end
        end

        npc:facePlayer(player, true)
        player:printToPlayer("Nudara : I don't want that!", xi.msg.channel.NS_SAY)
    end
end)

m:addOverride("xi.zones.Bastok_Markets.npcs.Nudara.onTrigger", function(player, npc)
    if player:getCharVar("KupoShield") == 0 then
        for keyItem, requiredItem in pairs(items) do
            if player:hasKeyItem(keyItem) then
                player:printToPlayer(string.format("Nudara : Trade me a %s or a %s to receive a special shield!", requiredItem[1][2], requiredItem[2][2]), xi.msg.channel.NS_SAY)
                return
            end
        end
    end

    player:startEvent(118)
end)

return m
