require("modules/module_utils")
require("scripts/globals/dynamis")
-----------------------------------
-- Antiqix    !pos -208.751 0.250 -24.296 151
-- Haggleblix !pos -257.312 1.618 105.367 147
-- Lootblox   !pos 216.576 0.062 -19.578 149
-----------------------------------
local m = Module:new("dynamis_singles_for_hundos")

m:addOverride("xi.zones.Castle_Oztroja.npcs.Antiqix.onTrade", function(player, npc, trade)
    local ID       = require("scripts/zones/Castle_Oztroja/IDs")
    local currency = {1449, 1450, 1451}
    local gil      = trade:getGil()
    local count    = trade:getItemCount()

    local shop =
    {
        7, 1312, -- Angel Skin
        8, 1518, -- Colossal Skull
        9, 1464, -- Lancewood Log
       23, 1463, -- Chronos Tooth
       24, 1467, -- Relic Steel
       25, 1462, -- Lancewood Lumber
       28, 658,  -- Damascus Ingot
    }

    local maps =
    {
        [xi.ki.MAP_OF_DYNAMIS_SAN_DORIA]  = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BASTOK]     = 10000,
        [xi.ki.MAP_OF_DYNAMIS_WINDURST]   = 10000,
        [xi.ki.MAP_OF_DYNAMIS_JEUNO]      = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BEAUCEDINE] = 15000,
        [xi.ki.MAP_OF_DYNAMIS_XARCABARD]  = 20000,
        [xi.ki.MAP_OF_DYNAMIS_VALKURM]    = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BUBURIMU]   = 10000,
        [xi.ki.MAP_OF_DYNAMIS_QUFIM]      = 10000,
        [xi.ki.MAP_OF_DYNAMIS_TAVNAZIA]   = 20000,
    }

    if player:hasKeyItem(xi.ki.VIAL_OF_SHROUDED_SAND) then
        if
            -- 100x O.Bronzepiece -> 1x M.Silverpiece
            npcUtil.tradeHasExactly(trade, 1453) and
            npcUtil.giveItem(player, { { 1452, 100 } })
        then
            player:tradeComplete()
            return
        elseif
            -- 100x One Byne Bill -> 1x 100 Byne Bill
            npcUtil.tradeHasExactly(trade, 1456) and
            npcUtil.giveItem(player, { { 1455, 100 } })
        then
            player:tradeComplete()
            return
        elseif
            -- 100x T.Whiteshell -> 1x L.Jadeshell
            npcUtil.tradeHasExactly(trade, 1450) and
            npcUtil.giveItem(player, { { 1449, 100 } })
        then
            player:tradeComplete()
            return
        end

        -- buy prismatic hourglass
        if gil == xi.settings.main.PRISMATIC_HOURGLASS_COST and count == 1 and not player:hasKeyItem(xi.ki.PRISMATIC_HOURGLASS) then
            player:startEvent(54)
        -- return timeless hourglass for refund
        elseif count == 1 and trade:hasItemQty(timelessHourglassID, 1) then
            player:startEvent(97)
        -- currency exchanges
        elseif count == xi.settings.main.CURRENCY_EXCHANGE_RATE and trade:hasItemQty(currency[1], xi.settings.main.CURRENCY_EXCHANGE_RATE) then
            player:startEvent(55, xi.settings.main.CURRENCY_EXCHANGE_RATE)
        elseif count == xi.settings.main.CURRENCY_EXCHANGE_RATE and trade:hasItemQty(currency[2], xi.settings.main.CURRENCY_EXCHANGE_RATE) then
            player:startEvent(56, xi.settings.main.CURRENCY_EXCHANGE_RATE)
        elseif count == 1 and trade:hasItemQty(currency[3], 1) then
            player:startEvent(58, currency[3], currency[2], xi.settings.main.CURRENCY_EXCHANGE_RATE)
        -- shop
        else
            local item
            local price

            for i = 1, 13, 2 do
                price = shop[i]
                item  = shop[i + 1]

                if count == price and trade:hasItemQty(currency[2], price) then
                    player:setLocalVar("hundoItemBought", item)
                    player:startEvent(57, currency[2], price, item)

                    break
                end
            end

        end
    end
end)

m:addOverride("xi.zones.Beadeaux.npcs.Haggleblix.onTrade", function(player, npc, trade)
    local ID       = require("scripts/zones/Beadeaux/IDs")
    local currency = {1455, 1456, 1457}
    local gil      = trade:getGil()
    local count    = trade:getItemCount()

    local shop =
    {
        7, 1313, -- Siren's Hair
        8, 1521, -- Slime Juice
        9, 1469, -- Wootz Ore
       12, 4246, -- Cantarella
       20, 1468, -- Marksman's Oil
       25, 1461, -- Wootz Ingot
       33, 1460, -- Koh-I-Noor
    }

    local maps =
    {
        [xi.ki.MAP_OF_DYNAMIS_SAN_DORIA]  = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BASTOK]     = 10000,
        [xi.ki.MAP_OF_DYNAMIS_WINDURST]   = 10000,
        [xi.ki.MAP_OF_DYNAMIS_JEUNO]      = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BEAUCEDINE] = 15000,
        [xi.ki.MAP_OF_DYNAMIS_XARCABARD]  = 20000,
        [xi.ki.MAP_OF_DYNAMIS_VALKURM]    = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BUBURIMU]   = 10000,
        [xi.ki.MAP_OF_DYNAMIS_QUFIM]      = 10000,
        [xi.ki.MAP_OF_DYNAMIS_TAVNAZIA]   = 20000,
    }

    if player:hasKeyItem(xi.ki.VIAL_OF_SHROUDED_SAND) then
        if
            -- 1x M.Silverpiece -> 100x O.Bronzepiece
            npcUtil.tradeHasExactly(trade, 1453) and
            npcUtil.giveItem(player, { { 1452, 100 } })
        then
            player:tradeComplete()
            return
        elseif
            -- 1x 100 Byne Bill -> 100x One Byne Bill
            npcUtil.tradeHasExactly(trade, 1456) and
            npcUtil.giveItem(player, { { 1455, 100 } })
        then
            player:tradeComplete()
            return
        elseif
            -- 1x L.Jadeshell -> 100x T.Whiteshell
            npcUtil.tradeHasExactly(trade, 1450) and
            npcUtil.giveItem(player, { { 1449, 100 } })
        then
            player:tradeComplete()
            return
        end

        -- buy prismatic hourglass
        if gil == xi.settings.main.PRISMATIC_HOURGLASS_COST and count == 1 and not player:hasKeyItem(xi.ki.PRISMATIC_HOURGLASS) then
            player:startEvent(134)
        -- return timeless hourglass for refund
        elseif count == 1 and trade:hasItemQty(timelessHourglassID, 1) then
            player:startEvent(153)
        -- currency exchanges
        elseif count == xi.settings.main.CURRENCY_EXCHANGE_RATE and trade:hasItemQty(currency[1], xi.settings.main.CURRENCY_EXCHANGE_RATE) then
            player:startEvent(135, xi.settings.main.CURRENCY_EXCHANGE_RATE)
        elseif count == xi.settings.main.CURRENCY_EXCHANGE_RATE and trade:hasItemQty(currency[2], xi.settings.main.CURRENCY_EXCHANGE_RATE) then
            player:startEvent(136, xi.settings.main.CURRENCY_EXCHANGE_RATE)
        elseif count == 1 and trade:hasItemQty(currency[3], 1) then
            player:startEvent(138, currency[3], currency[2], xi.settings.main.CURRENCY_EXCHANGE_RATE)

        -- shop
        else
            local item
            local price

            for i = 1, 13, 2 do
                price = shop[i]
                item  = shop[i + 1]

                if count == price and trade:hasItemQty(currency[2], price) then
                    player:setLocalVar("hundoItemBought", item)
                    player:startEvent(137, currency[2], price, item)
                    break
                end
            end
        end
    end
end)

m:addOverride("xi.zones.Davoi.npcs.Lootblox.onTrade", function(player, npc, trade)
    local ID       = require("scripts/zones/Davoi/IDs")
    local currency = {1452, 1453, 1454}
    local gil      = trade:getGil()
    local count    = trade:getItemCount()

    local shop =
    {
         5, 1295, -- Twincoon
         6, 1466, -- Relic Iron
         7, 1520, -- Goblin Grease
         8, 1516, -- Griffon Hide
        23, 1459, -- Griffon Leather
        25, 883,  -- Behemoth Horn
        28, 1458, -- Mammoth Tusk
    }

    local maps =
    {
        [xi.ki.MAP_OF_DYNAMIS_SAN_DORIA]   = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BASTOK]     = 10000,
        [xi.ki.MAP_OF_DYNAMIS_WINDURST]   = 10000,
        [xi.ki.MAP_OF_DYNAMIS_JEUNO]      = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BEAUCEDINE] = 15000,
        [xi.ki.MAP_OF_DYNAMIS_XARCABARD]  = 20000,
        [xi.ki.MAP_OF_DYNAMIS_VALKURM]    = 10000,
        [xi.ki.MAP_OF_DYNAMIS_BUBURIMU]   = 10000,
        [xi.ki.MAP_OF_DYNAMIS_QUFIM]      = 10000,
        [xi.ki.MAP_OF_DYNAMIS_TAVNAZIA]   = 20000,
    }

    if player:hasKeyItem(xi.ki.VIAL_OF_SHROUDED_SAND) then
        if
            -- 100x O.Bronzepiece -> 1x M.Silverpiece
            npcUtil.tradeHasExactly(trade, 1453) and
            npcUtil.giveItem(player, { { 1452, 100 } })
        then
            player:tradeComplete()
            return
        elseif
            -- 100x One Byne Bill -> 1x 100 Byne Bill
            npcUtil.tradeHasExactly(trade, 1456) and
            npcUtil.giveItem(player, { { 1455, 100 } })
        then
            player:tradeComplete()
            return
        elseif
            -- 100x T.Whiteshell -> 1x L.Jadeshell
            npcUtil.tradeHasExactly(trade, 1450) and
            npcUtil.giveItem(player, { { 1449, 100 } })
        then
            player:tradeComplete()
            return
        end

        -- buy prismatic hourglass
        if gil == xi.settings.main.PRISMATIC_HOURGLASS_COST and count == 1 and not player:hasKeyItem(xi.ki.PRISMATIC_HOURGLASS) then
            player:startEvent(134)
        -- return timeless hourglass for refund
        elseif count == 1 and trade:hasItemQty(timelessHourglassID, 1) then
            player:startEvent(153)
        -- currency exchanges
        elseif count == xi.settings.main.CURRENCY_EXCHANGE_RATE and trade:hasItemQty(currency[1], xi.settings.main.CURRENCY_EXCHANGE_RATE) then
            player:startEvent(135, xi.settings.main.CURRENCY_EXCHANGE_RATE)
        elseif count == xi.settings.main.CURRENCY_EXCHANGE_RATE and trade:hasItemQty(currency[2], xi.settings.main.CURRENCY_EXCHANGE_RATE) then
            player:startEvent(136, xi.settings.main.CURRENCY_EXCHANGE_RATE)
        elseif count == 1 and trade:hasItemQty(currency[3], 1) then
            player:startEvent(138, currency[3], currency[2], xi.settings.main.CURRENCY_EXCHANGE_RATE)
        -- shop
        else
            local item
            local price

            for i = 1, 13, 2 do
                price = shop[i]
                item  = shop[i + 1]

                if count == price and trade:hasItemQty(currency[2], price) then
                    player:setLocalVar("hundoItemBought", item)
                    player:startEvent(137, currency[2], price, item)
                    break
                end
            end
        end
    end
end)

return m
