require("modules/module_utils")
-----------------------------------
local m = Module:new("discount_assault_gear")

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Bhoy_Yhupplo.onEventFinish", function(player, csid, option)
    local items =
    {
        [ 1] = { itemid = xi.item.VELOCITY_EARRING,   price =  1500 },
        [ 2] = { itemid = xi.item.GARRULOUS_RING,     price =  2500 },
        [ 3] = { itemid = xi.item.GRANDIOSE_CHAIN,    price =  4000 },
        [ 4] = { itemid = xi.item.HURLING_BELT,       price =  5000 },
        [ 5] = { itemid = xi.item.INVIGORATING_CAPE,  price =  5000 },
        [ 6] = { itemid = xi.item.IMPERIAL_KAMAN,     price =  7500 },
        [ 7] = { itemid = xi.item.STORM_ZAGHNAL,      price =  7500 },
        [ 8] = { itemid = xi.item.STORM_FIFE,         price =  7500 },
        [ 9] = { itemid = xi.item.YIGIT_TURBAN,       price = 10000 },
        [10] = { itemid = xi.item.AMIR_DIRS,          price = 10000 },
        [11] = { itemid = xi.item.PAHLUWAN_KHAZAGAND, price = 10000 },
    }

    if csid == 277 then
        local selectiontype = bit.band(option, 0xF)

        if selectiontype == 1 and npcUtil.giveKeyItem(player, xi.ki.ILRUSI_ASSAULT_ORDERS) then
            -- taken assault mission
            player:addAssault(bit.rshift(option, 4))
            player:delKeyItem(xi.ki.IMPERIAL_ARMY_ID_TAG)
            player:addKeyItem(xi.ki.MAP_OF_ILRUSI_ATOLL)
        elseif selectiontype == 2 then
            -- purchased an item
            local item   = bit.rshift(option, 14)
            local choice = items[item]

            if choice and npcUtil.giveItem(player, choice.itemid) then
                player:delAssaultPoint(xi.assault.assaultArea.ILRUSI_ATOLL, choice.price)
            end
        end
    end
end)

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Isdebaaq.onEventFinish", function(player, csid, option)
    local items =
    {
        [ 1] = { itemid = xi.item.ANTIVENOM_EARRING,  price =  1500 },
        [ 2] = { itemid = xi.item.EBULLIENT_RING,     price =  2500 },
        [ 3] = { itemid = xi.item.ENLIGHTENED_CHAIN,  price =  4000 },
        [ 4] = { itemid = xi.item.SPECTRAL_BELT,      price =  5000 },
        [ 5] = { itemid = xi.item.BULLSEYE_CAPE,      price =  5000 },
        [ 6] = { itemid = xi.item.STORM_TULWAR,       price =  7500 },
        [ 7] = { itemid = xi.item.IMPERIAL_NEZA,      price =  7500 },
        [ 8] = { itemid = xi.item.STORM_TABAR,        price =  7500 },
        [ 9] = { itemid = xi.item.YIGIT_GAGES,        price = 10000 },
        [10] = { itemid = xi.item.AMIR_BOOTS,         price = 10000 },
        [11] = { itemid = xi.item.PAHLUWAN_SERAWEELS, price = 10000 },
    }

    if csid == 274 then
        local selectiontype = bit.band(option, 0xF)

        if selectiontype == 1 and npcUtil.giveKeyItem(player, xi.ki.MAMOOL_JA_ASSAULT_ORDERS) then
            -- taken assault mission
            player:addAssault(bit.rshift(option, 4))
            player:delKeyItem(xi.ki.IMPERIAL_ARMY_ID_TAG)
            player:addKeyItem(xi.ki.MAP_OF_THE_TRAINING_GROUNDS)
        elseif selectiontype == 2 then
            -- purchased an item
            local item   = bit.rshift(option, 14)
            local choice = items[item]

            if choice and npcUtil.giveItem(player, choice.itemid) then
                player:delAssaultPoint(xi.assault.assaultArea.MAMOOL_JA_TRAINING_GROUNDS, choice.price)
            end
        end
    end
end)

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Lageegee.onEventFinish", function(player, csid, option)
    local items =
    {
        [ 1] = { itemid = xi.item.VISION_EARRING,    price =  1500 },
        [ 2] = { itemid = xi.item.UNYIELDING_RING,   price =  2500 },
        [ 3] = { itemid = xi.item.FORTIFIED_CHAIN,   price =  4000 },
        [ 4] = { itemid = xi.item.RESOLUTE_BELT,     price =  5000 },
        [ 5] = { itemid = xi.item.BUSHIDO_CAPE,      price =  5000 },
        [ 6] = { itemid = xi.item.KHANJAR,           price =  7500 },
        [ 7] = { itemid = xi.item.HOTARUMARU,        price =  7500 },
        [ 8] = { itemid = xi.item.IMPERIAL_GUN,      price =  7500 },
        [ 9] = { itemid = xi.item.AMIR_PUGGAREE,     price = 10000 },
        [10] = { itemid = xi.item.PAHLUWAN_CRACKOWS, price = 10000 },
        [11] = { itemid = xi.item.YIGIT_GOMLEK,      price = 10000 },
    }

    if csid == 276 then
        local selectiontype = bit.band(option, 0xF)

        if selectiontype == 1 and npcUtil.giveKeyItem(player, xi.ki.PERIQIA_ASSAULT_ORDERS) then
            -- taken assault mission
            player:addAssault(bit.rshift(option, 4))
            player:delKeyItem(xi.ki.IMPERIAL_ARMY_ID_TAG)
            player:addKeyItem(xi.ki.MAP_OF_PERIQIA)
        elseif selectiontype == 2 then
            -- purchased an item
            local item   = bit.rshift(option, 14)
            local choice = items[item]

            if choice and npcUtil.giveItem(player, choice.itemid) then
                player:delAssaultPoint(xi.assault.assaultArea.PERIQIA, choice.price)
            end
        end
    end
end)

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Yahsra.onEventFinish", function(player, csid, option)
    local items =
    {
        [ 1] = { itemid = xi.item.STOIC_EARRING,      price =  1500 },
        [ 2] = { itemid = xi.item.UNFETTERED_RING,    price =  2500 },
        [ 3] = { itemid = xi.item.TEMPERED_CHAIN,     price =  4000 },
        [ 4] = { itemid = xi.item.POTENT_BELT,        price =  5000 },
        [ 5] = { itemid = xi.item.MIRACULOUS_CAPE,    price =  5000 },
        [ 6] = { itemid = xi.item.YIGIT_BULAWA,       price =  5000 },
        [ 7] = { itemid = xi.item.IMPERIAL_BHUJ,      price =  7500 },
        [ 8] = { itemid = xi.item.PAHLUWAN_PATAS,     price =  7500 },
        [ 9] = { itemid = xi.item.AMIR_KOLLUKS,       price = 10000 },
        [10] = { itemid = xi.item.PAHLUWAN_QALANSUWA, price = 10000 },
        [11] = { itemid = xi.item.YIGIT_SERAWEELS,    price = 10000 },
    }

    if csid == 273 then
        local selectiontype = bit.band(option, 0xF)

        if selectiontype == 1 and npcUtil.giveKeyItem(player, xi.ki.LEUJAOAM_ASSAULT_ORDERS) then
            -- taken assault mission
            player:addAssault(bit.rshift(option, 4))
            player:delKeyItem(xi.ki.IMPERIAL_ARMY_ID_TAG)
            player:addKeyItem(xi.ki.MAP_OF_LEUJAOAM_SANCTUM)
        elseif selectiontype == 2 then
            -- purchased an item
            local item   = bit.rshift(option, 14)
            local choice = items[item]

            if choice and npcUtil.giveItem(player, choice.itemid) then
                player:delAssaultPoint(xi.assault.assaultArea.LEUJAOAM_SANCTUM, choice.price)
            end
        end
    end
end)

m:addOverride("xi.zones.Aht_Urhgan_Whitegate.npcs.Famad.onEventFinish", function(player, csid, option)
    local items =
    {
        [ 1] = { itemid = xi.item.INSOMNIA_EARRING,  price =  1500 },
        [ 2] = { itemid = xi.item.HALE_RING,         price =  2500 },
        [ 3] = { itemid = xi.item.CHIVALROUS_CHAIN,  price =  4000 },
        [ 4] = { itemid = xi.item.PRECISE_BELT,      price =  5000 },
        [ 5] = { itemid = xi.item.INTENSIFYING_CAPE, price =  5000 },
        [ 6] = { itemid = xi.item.IMPERIAL_POLE,     price =  7500 },
        [ 7] = { itemid = xi.item.DOOMBRINGER,       price =  7500 },
        [ 8] = { itemid = xi.item.SAYOSAMONJI,       price =  7500 },
        [ 9] = { itemid = xi.item.PAHLUWAN_DASTANAS, price = 10000 },
        [10] = { itemid = xi.item.YIGIT_CRACKOWS,    price = 10000 },
        [11] = { itemid = xi.item.AMIR_KORAZIN,      price = 10000 },
    }

    if csid == 275 then
        local selectiontype = bit.band(option, 0xF)

        if selectiontype == 1 and npcUtil.giveKeyItem(player, xi.ki.LEBROS_ASSAULT_ORDERS) then
            -- taken assault mission
            player:addAssault(bit.rshift(option, 4))
            player:delKeyItem(xi.ki.IMPERIAL_ARMY_ID_TAG)
            player:addKeyItem(xi.ki.MAP_OF_LEBROS_CAVERN)
        elseif selectiontype == 2 then
            -- purchased an item
            local item   = bit.rshift(option, 14)
            local choice = items[item]

            if choice and npcUtil.giveItem(player, choice.itemid) then
                player:delAssaultPoint(xi.assault.assaultArea.LEBROS_CAVERN, choice.price)
            end
        end
    end
end)

return m
