-------------------------------------
-- Dealer Moogle - Redeem Kupon A-Ab
-------------------------------------
require("scripts/globals/npc_util")
require("scripts/globals/dealer_moogle")
require("modules/module_utils")
-------------------------------------
local m = Module:new("dealer_moogle")

local abjItems =
{
    {
        "Zenith Attire",
        {
            { "Zenith Crown +1",        13877, 0 },
            { "Dalmatica +1",           13788, 0 },
            { "Zenith Mitts +1",        14007, 0 },
            { "Zenith Slacks +1",       14248, 0 },
            { "Zenith Pumps +1",        14124, 0 },
        },
    },
    {
        "Shura Attire",
        {
            { "Shura Zunari Kabuto +1", 13935, 0 },
            { "Shura Togi +1",          14388, 0 },
            { "Shura Sune-Ate +1",      14185, 0 },
            { "Shura Haidate +1",       14304, 0 },
            { "Shura Kote +1",          14822, 0 },
        },
    },
    {
        "Kaiser Attire",
        {
            { "Kaiser Schaller",        13911, 0 },
            { "Kaiser Cuirass",         14370, 0 },
            { "Kaiser Handschuhs",      14061, 0 },
            { "Kaiser Diechlings",      14283, 0 },
            { "Kaiser Schuhs",          14163, 0 },
        },
    },
    {
        "Hecatomb Attire",
        {
            { "Hecatomb Cap +1",        13928, 0 },
            { "Hecatomb Harness +1",    14379, 0 },
            { "Hecatomb Mittens +1",    14077, 0 },
            { "Hecatomb Subligar +1",   14309, 0 },
            { "Hecatomb Leggings +1",   14181, 0 },
        },
    },
    {
        "Blood Attire",
        {
            { "Blood Mask",             13909, 0 },
            { "Blood Scale Mail",       14368, 0 },
            { "Blood Finger Gauntlets", 14059, 0 },
            { "Blood Cuisses",          14281, 0 },
            { "Blood Greaves",          14161, 0 },
        },
    },
    {
        "Armada Attire",
        {
            { "Armada Celata",          13924, 0 },
            { "Armada Hauberk",         14371, 0 },
            { "Armada Sollerets",       14175, 0 },
            { "Armada Breeches",        14296, 0 },
            { "Armada Mufflers",        14816, 0 },
        },
    },
    {
        "Valkyries (Plate)",
        {
            { "Valkyries Helm",         16114, 0 },
            { "Valk. Breastplate",      14574, 0 },
            { "Valk. Gauntlets",        14996, 0 },
            { "Valkyries Cuishes",      15656, 0 },
            { "Valk. Sabatons",         15741, 0 },
        },
    },
    {
        "Valkyries (Cloth)",
        {
            { "Valkyries Hat",          16116, 0 },
            { "Valkyries Coat",         14576, 0 },
            { "Valkyries Cuffs",        14998, 0 },
            { "Valkyries Trews",        15658, 0 },
            { "Valkyries Clogs",        15743, 0 },
        },
    },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function completeTransaction(player, npc, item)
    local itemName     = item[1]
    local itemID       = item[2]
    local confirmMenu  =
    {
        title   = "Confirm purchase",
        options =
        {
            {
                "No, I've changed my mind.",
                function()
                end,
            },
            {
                string.format("Purchase: %s", itemName),
                function(playerArg)
                    if npcUtil.giveItem(player, itemID) then
                        player:tradeComplete()
                        player:printToPlayer("Dealer Moogle: Congratulations, Kupo! Enjoy your shiny new stuff!", xi.msg.channel.NS_SAY)
                    else
                        player:printToPlayer("Dealer Moogle: Uh oh, Kupo, something went wrong. Do you have enough inventory space?", xi.msg.channel.NS_SAY)
                        return
                    end
                end,
            },
        },
    }

    delaySendMenu(player, confirmMenu)
end

local function confirmPurchase(player, npc, item)
    completeTransaction(player, npc, item)
end

cexi.util.reloadOverride(m, "xi.dealerMoogle.onTrade", function(player, npc, trade)
    if npcUtil.tradeHasExactly(trade, xi.item.MOG_KUPON_A_AB) then
        local title = "Rewards"
        
        npc:facePlayer(player, true)
        cexi.util.categoryMenu(player, npc, abjItems, confirmPurchase, title)
    end
end)

return m
