require("modules/module_utils")
require('scripts/globals/npc_util')
require('scripts/globals/quests')
require('scripts/globals/missions')
-----------------------------------

local m = Module:new("curio_vendor_moogle")

local cvmZones =
{
    { zone = "Port_Bastok",    pos = "(K-13)" },
    { zone = "Port_San_dOria", pos = "(J-9)"  },
    { zone = "Port_Windurst",  pos = "(M-4)"  },
}

local stock =
{
    {
        { 4112,    1000,    0                         }, -- Potion
        { 4116,    3500,    0                         }, -- Hi-Potion
        { 4120,    7500,    xi.ki.RHAPSODY_IN_WHITE   }, -- X-Potion
        { 4156,     500,    0                         }, -- Mulsum
        { 4128,    1000,    0                         }, -- Ether
        { 4132,    3500,    0                         }, -- Hi-Ether
        { 4136,    7500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Super Ether
        { 4145,   20000,    0                         }, -- Elixir
        { 4144,   40000,    0                         }, -- Hi-Elixir
        { 4174,   25000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Vile Elixir
        { 4175,   50000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Vile Elixir +1
        { 4148,     300,    0                         }, -- Antidote
        { 4150,    1000,    0                         }, -- Eye Drops
        { 4151,    1750,    0                         }, -- Echo Drops
        { 4164,    3500,    0                         }, -- Prism Powder
        { 4165,    3500,    0                         }, -- Silent Oil
        { 4166,     250,    0                         }, -- Deodorizer
        { 4157,    4000,    0                         }, -- Poison Potion
        { 5418,    2000,    0                         }, -- Tincture
        { 4155,    8000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Remedy
        { 4149,   30000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Panacea
        { 4172,   10000,    0                         }, -- Reraiser
        { 4173,   20000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Hi-Reraiser
        { 5770,   50000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Super Reraiser
    },
    {
        { 1021,     500,    0                          }, -- Hatchet
        { 605,      200,    0                          }, -- Pickaxe
        { 1020,     300,    0                          }, -- Sickle
        { 4219,     400,    0                          }, -- Stone Quiver
        { 4220,     680,    0                          }, -- Bone Quiver
        { 4225,    1200,    0                          }, -- Iron Quiver
        { 4221,    4000,    0                          }, -- Beetle Quiver
        { 4226,    4000,    0                          }, -- Silver Quiver
        { 4222,    8000,    0                          }, -- Horn Quiver
        { 5333,   12000,    0                          }, -- Sleep Quiver
        { 4223,   12000,    0                          }, -- Scorpion Quiver
        { 4224,   25000,    xi.ki.RHAPSODY_IN_WHITE    }, -- Demon Quiver
        { 5332,   30000,    xi.ki.RHAPSODY_IN_CRIMSON  }, -- Kabura Quiver
    --  { 5819,    9900,    0                          }, -- Antlion Quiver
        { 4227,     400,    0                          }, -- Bronze Bolt Quiver
        { 5334,    6000,    0                          }, -- Blind Bolt Quiver
        { 5335,   12000,    xi.ki.RHAPSODY_IN_WHITE    }, -- Acid Bolt Quiver
        { 5337,   12000,    xi.ki.RHAPSODY_IN_WHITE    }, -- Sleep Bolt Quiver
        { 5339,   20000,    xi.ki.RHAPSODY_IN_WHITE    }, -- Bloody Bolt Quiver
        { 5338,   12000,    0                          }, -- Venom Bolt Quiver
        { 5336,   12000,    0                          }, -- Holy Bolt Quiver
        { 4228,   12000,    0                          }, -- Mythril Bolt Quiver
        { 4229,   16000,    0                          }, -- Darksteel Bolt Quiver
    --  { 5820,    9460,    0                          }, -- Darkling Bolt Quiver
    --  { 5821,    9790,    0                          }, -- Fusion Bolt Quiver
        { 5359,     400,    0                          }, -- Bronze Bullet Pouch
        { 5363,    6000,    0                          }, -- Bullet Pouch
        { 5341,    6000,    0                          }, -- Spartan Bullet Pouch
        { 5353,   20000,    0                          }, -- Iron Bullet Pouch
        { 5340,   20000,    xi.ki.RHAPSODY_IN_WHITE    }, -- Silver Bullet Pouch
        { 5342,   20000,    xi.ki.RHAPSODY_IN_CRIMSON  }, -- Corsair Bullet Pouch
        { 5416,   25000,    xi.ki.RHAPSODY_IN_WHITE    }, -- Steel Bullet Pouch
    --  { 5822,    9680,    0                          }, -- Dweomer Bullet Pouch
    --  { 5823,    9900,    0                          }, -- Oberon Bullet Pouch
        { 6299,    3000,    0                          }, -- Shuriken Pouch
        { 6297,    6000,    0                          }, -- Juji Shuriken Pouch
        { 6298,    8000,    0                          }, -- Manji Shuriken Pouch
        { 6302,   10000,    xi.ki.RHAPSODY_IN_WHITE    }, -- Fuma Shuriken Pouch
    --  { 6303,    9900,    0                          }, -- Iga Shuriken Pouch
    },
    {
        { 5308,    5000,    0                         }, -- Toolbag (Uchi)
        { 5309,    5000,    0                         }, -- Toolbag (Tsurara)
        { 5310,    5000,    0                         }, -- Toolbag (Kawahori-Ogi)
        { 5311,    5000,    0                         }, -- Toolbag (Makibishi)
        { 5312,    5000,    0                         }, -- Toolbag (Hiraishin)
        { 5313,    5000,    0                         }, -- Toolbag (Mizu-Deppo)
        { 5314,   12500,    xi.ki.RHAPSODY_IN_WHITE,  }, -- Toolbag (Shihei)
        { 5315,   12500,    0                         }, -- Toolbag (Jusatsu)
        { 5316,   12500,    0                         }, -- Toolbag (Kaginawa)
        { 5317,   12500,    0                         }, -- Toolbag (Sairui-Ran)
        { 5318,   12500,    0                         }, -- Toolbag (Kodoku)
        { 5319,   12500,    0                         }, -- Toolbag (Shinobi-Tabi)
        { 5417,   12500,    0                         }, -- Toolbag (Sanjaku-Tenugui)
        { 5734,    7500,    0                         }, -- Toolbag (Soshi)
        { 5867,   30000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Toolbag (Inoshishinofuda) (Master Tool)
        { 5869,   30000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Toolbag (Chonofuda)       (Master Tool)
        { 5868,   30000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Toolbag (Shikanofuda)     (Master Tool)
        { 5402,   10000,    0                         }, -- Fire Card Case
        { 5405,   10000,    0                         }, -- Earth Card Case
        { 5407,   10000,    0                         }, -- Water Card Case
        { 5404,   10000,    0                         }, -- Wind Card Case
        { 5403,   10000,    0                         }, -- Ice Card Case
        { 5406,   10000,    0                         }, -- Thunder Card Case
        { 5408,   10000,    0                         }, -- Light Card Case
        { 5409,   10000,    0                         }, -- Dark Card Case
        { 5870,   25000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Trump Card Case           (Master Tool)
    },
    {
        { 5703,     120,    0                         }, -- Uleguerand Milk
        { 4299,     500,    0                         }, -- Orange au Lait
        { 4300,     750,    0                         }, -- Apple au Lait
        { 4301,    1500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Pear au Lait
        { 4302,    3000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Pamama au Lait
        { 4422,     250,    0                         }, -- Orange Juice
        { 4424,    2500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Melon Juice
        { 4558,    4000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Yagudo Drink
        { 4405,     160,    0                         }, -- Rice Ball
        { 4277,    6000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Tonosama Rice Ball
        { 4376,     250,    0                         }, -- Meat Jerky
        { 4271,    3500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Rice Dumpling
        { 4381,    4000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Meat Mithkabob
        { 4456,    2000,    0                         }, -- Boiled Crab
        { 4398,    5000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Fish Mithkabob
        { 5166,    8000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Coeurl Sub
        { 4538,    6000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Roast Pipira
        { 6217,     500,    0                         }, -- Anchovy Slice
        { 6211,    4500,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Marinara Slice
        { 5752,    7000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Pot-auf-feu
        { 4488,    1000,    0                         }, -- Jack-o'-Lantern
        { 5721,    5000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Crab Sushi
        { 5665,    7000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Fin Sushi
        { 5176,    7500,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Bream Sushi
        { 5178,    8000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Dorado Sushi
        { 5766,    4100,    xi.ki.RHAPSODY_IN_WHITE   }, -- Butter Crepe
        { 5775,    4100,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Chocolate Crepe
        { 4413,     600,    0                         }, -- Apple Pie
        { 4421,    2000,    0                         }, -- Melon Pie
        { 5718,    3000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Cream Puff
        { 4410,     350,    0                         }, -- Roast Mushroom
        { 4394,      33,    0                         }, -- Ginger Cookie
        { 5782,    5000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Sugar Rusk
        { 5783,   10000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Chocolate Rusk
        { 5779,    5000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Cherry Macaron
        { 5780,   10000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Coffee Macaron
        { 5885,    3000,    0                         }, -- Saltena
        { 5886,    5000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Elshena
        { 5887,    7500,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Montagna
        { 5889,    3000,    0                         }, -- Stuffed Pitaru
        { 5890,    5000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Poultry Pitaru
        { 5891,    7000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Seafood Pitaru
        { 6258,    8000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Shiromochi
        { 6262,   10000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Kusamochi
        { 6260,    8000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Akamochi
        { 5547,    7500,    0                         }, -- Beef Stewpot
        { 5727,    8000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Zaru Soba
        { 4104,   15000,    0                         }, -- Fire Cluster
        { 4105,   10000,    0                         }, -- Ice Cluster
        { 4106,   10000,    0                         }, -- Wind Cluster
        { 4107,   10000,    0                         }, -- Earth Cluster
        { 4108,   10000,    0                         }, -- Lightning Cluster
        { 4109,   10000,    0                         }, -- Water Cluster
        { 4110,   15000,    0                         }, -- Light Cluster
        { 4111,   15000,    0                         }, -- Dark Cluster
    },
    {
        { 4181,       1000,    0                         }, -- Instant Warp
        { 4182,       2000,    0                         }, -- Instant Reraise
        { 5428,       1000,    0                         }, -- Instant Retrace
        { 5988,       3000,    0                         }, -- Instant Protect
        { 5989,       3000,    0                         }, -- Instant Shell
        { 5990,       3000,    0                         }, -- Instant Stoneskin
        { 10140,    350000,    0                         }, -- Koru Moru
        { 10160,    250000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Zeid II
        { 10157,    200000,    xi.ki.RHAPSODY_IN_WHITE   }, -- Semih Lafihna
        { 10152,    500000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Qultada
        { 10130,    750000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Elivira
        { 10162,    500000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Kupofried
        { 10118,    500000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Naja Salaheem
        { 10120,    500000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Lehko Habhoka
        { 10136,    500000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Uka Totlihn
    },
    {
        { 1024,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Ghelsba Chest Key
        { 1025,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Palborough Chest Key
        { 1026,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Giddeus Chest Key
        { 1027,    15000,    0                         }, -- Ranperre Chest Key
        { 1028,    15000,    0                         }, -- Dangurf Chest Key
        { 1029,    15000,    0                         }, -- Horutoto Chest Key
        { 1030,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Ordelle Chest Key
        { 1031,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Gusgen Chest Key
        { 1032,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Shakhrami Chest Key
        { 1033,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Davoi Chest Key
        { 1034,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Beadeaux Chest Key
        { 1035,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Oztroja Chest Key
        { 1036,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Delkfutt Chest Key
        { 1037,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Fei'Yin Chest Key
        { 1038,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Zvahl Chest Key
        { 1039,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Eldieme Chest Key
        { 1040,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Nest Chest Key
        { 1041,    20000,    xi.ki.RHAPSODY_IN_CRIMSON }, -- Garlaige Chest Key
        { 1043,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Beadeaux Coffer Key
        { 1042,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Davoi Coffer Key
        { 1044,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Oztroja Coffer Key
        { 1045,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Nest Coffer Key
        { 1046,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Eldieme Coffer Key
        { 1047,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Garlaige Coffer Key
        { 1048,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Zvhal Coffer Key
        { 1049,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Uggalepih Coffer Key
        { 1050,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Den Coffer Key
        { 1051,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Kuftal Coffer Key
        { 1052,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Boyahda Coffer Key
        { 1053,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Cauldron Coffer Key
        { 1054,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Quicksand Coffer Key
        { 1055,     2500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Grotto Chest Key
        { 1056,     2500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Onzozo Chest Key
        { 1057,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Toraimarai Coffer Key
        { 1058,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Ru'Aun Coffer Key
        { 1059,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Grotto Coffer Key
        { 1060,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Ve'Lugannon Coffer Key
        { 1061,     2500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Sacrarium Chest Key
        { 1062,     2500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Oldton Chest Key
        { 1063,     5000,    xi.ki.RHAPSODY_IN_UMBER   }, -- Newton Coffer Key
        { 1064,     2500,    xi.ki.RHAPSODY_IN_WHITE   }, -- Pso'Xja Chest Key
    },
}

local function createShop(player, itemList)
    player:createShop(#itemList, -1)

    for _, item in pairs(itemList) do
        if item[3] == 0 or player:hasKeyItem(item[3]) then
            player:addShopItem(item[1], item[2])
        end
    end

    player:sendMenu(2)
end

for _, location in ipairs(cvmZones) do
    local cvmLuaFile = string.format("xi.zones.%s.npcs.Curio_Vendor_Moogle", location.zone)

    cexi.util.reloadOverride(m, cvmLuaFile .. ".onTrigger", function(player, npc)
        -- The player gets RHAPSODY_IN_WHITE either by completing "Out of Stock"
        -- or by achieving Level 60 in a craft and speaking with Momiji.
        local cvmStatus  = player:getCharVar("[CQ]CURIO_MOOGLES") == 1
        local rhapsodyKI = player:hasKeyItem(xi.ki.RHAPSODY_IN_WHITE)

        if rhapsodyKI or cvmStatus then
            -- Open the shop
            player:startEvent(9601)
        elseif player:isCrystalWarrior() then
            player:printToPlayer("Crystal Warriors cannot use the Curio Vendor Moogle.", xi.msg.channel.SYSTEM_3)
            return
        else
            -- Player doesn't have access
            player:printToPlayer(string.format("You must first complete the quest \"Out of Stock\" from the Shady Dealer %s.", location.pos), xi.msg.channel.SYSTEM_3)
            player:startEvent(9600)
        end
    end)

    cexi.util.reloadOverride(m, cvmLuaFile .. ".onEventFinish", function(player, csid, option, npc)
        if
            csid == 9601 and
            option >= 1 and option <= 6
        then
            createShop(player, stock[option])
        end
    end)
end

return m
