-----------------------------------
-- CatsEyeXI Relic System
-----------------------------------
require("modules/module_utils")
require("scripts/globals/npc_util")
-----------------------------------
local m = Module:new("crafting_relics_and_exchanges")

local relics =
{
    [xi.item.MANDAU] =
    {
        itemName = "Mandau",
        zoneName = "The_Sanctuary_of_ZiTah",
        npcName  = "relic_mandau",
        eventID  = 207,
        upgrade  = xi.item.BATARDEAU,
        required =
        {
            xi.item.TEN_THOUSAND_BYNE_BILL,
            xi.item.ORNATE_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.BATARDEAU,
        },
    },
    [xi.item.MJOLLNIR] =
    {
        itemName = "Mjollnir",
        zoneName = "The_Sanctuary_of_ZiTah",
        npcName  = "relic_mjollnir",
        eventID  = 216,
        upgrade  = xi.item.GULLINTANI,
        required =
        {
            xi.item.RANPERRE_GOLDPIECE,
            xi.item.HEAVENLY_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.GULLINTANI,
        },
    },
    [xi.item.SPHARAI] =
    {
        itemName = "Spharai",
        zoneName = "Castle_Oztroja",
        npcName  = "relic",
        eventID  = 59,
        upgrade  = xi.item.CAESTUS,
        required =
        {
            xi.item.TEN_THOUSAND_BYNE_BILL,
            xi.item.MYSTIC_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.CAESTUS,
        },
    },
    [xi.item.EXCALIBUR] =
    {
        itemName = "Excalibur",
        zoneName = "Dragons_Aery",
        npcName  = "relic",
        eventID  = 3,
        upgrade  = xi.item.CALIBURN,
        required =
        {
            xi.item.RANPERRE_GOLDPIECE,
            xi.item.HOLY_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.CALIBURN,
        },
    },
    [xi.item.GUTTLER] =
    {
        itemName = "Guttler",
        zoneName = "Western_Altepa_Desert",
        npcName  = "relic",
        eventID  = 205,
        upgrade  = xi.item.OGRE_KILLER,
        required =
        {
            xi.item.RIMILALA_STRIPESHELL,
            xi.item.RUNAEIC_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.OGRE_KILLER,
        },
    },
    [xi.item.GUNGNIR] =
    {
        itemName = "Gungnir",
        zoneName = "RuAun_Gardens",
        npcName  = "relic",
        eventID  = 60,
        upgrade  = xi.item.GAE_ASSAIL,
        required =
        {
            xi.item.RIMILALA_STRIPESHELL,
            xi.item.STELLAR_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.GAE_ASSAIL,
        },
    },
    [xi.item.RAGNAROK] =
    {
        itemName = "Ragnarok",
        zoneName = "Beaucedine_Glacier",
        npcName  = "relic",
        eventID  = 139,
        upgrade  = xi.item.VALHALLA,
        required =
        {
            xi.item.RANPERRE_GOLDPIECE,
            xi.item.INTRICATE_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.VALHALLA,
        },
    },
    [xi.item.GJALLARHORN] =
    {
        itemName = "Gjallarhorn",
        zoneName = "Valley_of_Sorrows",
        npcName  = "relic",
        eventID  = 15,
        upgrade  = xi.item.MILLENNIUM_HORN,
        required =
        {
            xi.item.RIMILALA_STRIPESHELL,
            xi.item.MYSTERIAL_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.MILLENNIUM_HORN,
        },
    },
    [xi.item.BRAVURA] =
    {
        itemName = "Bravura",
        zoneName = "RuLude_Gardens",
        npcName  = "relic",
        eventID  = 10035,
        upgrade  = xi.item.ABADDON_KILLER,
        required =
        {
            xi.item.TEN_THOUSAND_BYNE_BILL,
            xi.item.SERAPHIC_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.ABADDON_KILLER,
        },
    },
    [xi.item.AMANOMURAKUMO] =
    {
        itemName = "Amanomurakumo",
        zoneName = "Horlais_Peak",
        npcName  = "relic",
        eventID  = 13,
        upgrade  = xi.item.TOTSUKANOTSURUGI,
        required =
        {
            xi.item.RANPERRE_GOLDPIECE,
            xi.item.DIVINE_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.TOTSUKANOTSURUGI,
        },
    },
    [xi.item.APOCALYPSE] =
    {
        itemName = "Apocalypse",
        zoneName = "North_Gustaberg",
        npcName  = "relic",
        eventID  = 254,
        upgrade  = xi.item.BEC_DE_FAUCON,
        required =
        {
            xi.item.RIMILALA_STRIPESHELL,
            xi.item.TENEBROUS_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.BEC_DE_FAUCON,
        },
    },
    [xi.item.AEGIS] =
    {
        itemName = "Aegis",
        zoneName = "Carpenters_Landing",
        npcName  = "relic",
        eventID  = 44,
        upgrade  = xi.item.ANCILE,
        required =
        {
            xi.item.RANPERRE_GOLDPIECE,
            xi.item.SUPERNAL_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.ANCILE,
        },
    },
    [xi.item.KIKOKU] =
    {
        itemName = "Kikoku",
        zoneName = "Sea_Serpent_Grotto",
        npcName  = "relic",
        eventID  = 11,
        upgrade  = xi.item.YOSHIMITSU,
        required =
        {
            xi.item.TEN_THOUSAND_BYNE_BILL,
            xi.item.DEMONIAC_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.YOSHIMITSU,
        },
    },
    [xi.item.CLAUSTRUM] =
    {
        itemName = "Claustrum",
        zoneName = "Ifrits_Cauldron",
        npcName  = "relic",
        eventID  = 32,
        upgrade  = xi.item.THYRUS,
        required =
        {
            xi.item.RIMILALA_STRIPESHELL,
            xi.item.CELESTIAL_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.THYRUS,
        },
    },
    [xi.item.YOICHINOYUMI] =
    {
        itemName = "Yoichinoyumi",
        zoneName = "Cape_Teriggan",
        npcName  = "relic",
        eventID  = 18,
        upgrade  = xi.item.FUTATOKOROTO,
        required =
        {
            xi.item.RANPERRE_GOLDPIECE,
            xi.item.SNARLED_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.FUTATOKOROTO,
        },
    },
    [xi.item.ANNIHILATOR] =
    {
        itemName = "Annihilator",
        zoneName = "Metalworks",
        npcName  = "relic",
        eventID  = 843,
        upgrade  = xi.item.FERDINAND,
        required =
        {
            xi.item.TEN_THOUSAND_BYNE_BILL,
            xi.item.ETHEREAL_FRAGMENT,
            xi.item.SHARD_OF_NECROPSYCHE,
            xi.item.FERDINAND,
        },
    },
}

local function delaySendMenu(player, menu)
    player:timer(100, function(playerArg)
        playerArg:customMenu(menu)
    end)
end

local function triggerRelic(player, relicId)
    local ID = zones[player:getZoneID()]

    if player:getCharVar("RelicWeaponVoucher") == 1 then
        delaySendMenu(player, {
            title = fmt("Will you choose {}?", relics[relicId].itemName),
            options =
            {
                {
                    "No, I haven't decided yet.",
                    function()
                    end,
                },
                {
                    "Yes, I'm sure.",
                    function()
                        if npcUtil.giveItem(player, relicId) then
                            player:ceAnimate(player, player, 113, 4)
                            player:setCharVar("RelicWeaponVoucher", 0)
                            print(fmt("[RELIC]{} redeemed a RelicWeaponVoucher and received {}.", player:getName(), relics[relicId].itemName))
                        end
                    end,
                },
            },
        })
    else
        player:messageSpecial(ID.text.NOTHING_OUT_OF_ORDINARY)
    end
end

local function tradeRelic(player, trade, relicID)
    for itemID, _ in pairs(relics) do
        if npcUtil.tradeHas(trade, itemID) then
            if npcUtil.giveItem(player, relicID) then
                player:tradeComplete()
            end

            return
        end
    end
end

for relicItem, relic in pairs(relics) do
    local npcPath = string.format("xi.zones.%s.npcs.%s", relic.zoneName, relic.npcName)

    cexi.util.reloadOverride(m, npcPath .. ".onTrigger", function(player, npc)
        triggerRelic(player, relicItem)
    end)

    cexi.util.reloadOverride(m, npcPath .. ".onTrade", function(player, npc, trade)
        local currentRelic = player:getCharVar("RELIC_IN_PROGRESS")

        -- Check if requirements are obtained through upgrades or new player reward (0)
        if
            (currentRelic == relic.upgrade) or (currentRelic == 0) and
            npcUtil.tradeHasExactly(trade, relic.required)
        then
            if player:isCrystalWarrior() then
                cexi.crystal_warrior.announcement.worldFirst(
                    player,
                    string.format("CW_RELIC_%s", string.upper(relic.itemName)),
                    string.format("%s is the first Crystal Warrior to obtain %s!", player:getName(), relic.itemName)
                )
            end

            print(fmt("[RELIC]{} obtained {}.", player:getName(), relic.itemName))

            -- If this is acquired normally, reset relic stage
            if currentRelic == relic.upgrade then
                player:setCharVar("RELIC_IN_PROGRESS", 0)
            end

            player:tradeComplete()
            player:startEvent(relic.eventID, relicItem)

        elseif trade:getGil() == 5000000 then
            tradeRelic(player, trade, relicItem)
        end
    end)
end

local function momijiSay(player, npc, str)
    npc:facePlayer(player, true)
    player:printToPlayer("Momiji : " .. str, xi.msg.channel.NS_SAY)
end

-- Start Crafting Relics (Momiji, Lower Jeuno)
cexi.util.reloadOverride(m, "xi.zones.Lower_Jeuno.npcs.Momiji.onTrigger", function(player, npc)
    if
        player:isCrystalWarrior() or
        player:isClassicMode()
    then
        momijiSay(player, npc, "Oh no! You're going to have to get that relic the old fashioned way!")
        return
    end

    if player:getCharVar("FreeRelic") == 1 then
        if player:getCharVar("RelicWeaponVoucher") == 1 then
            momijiSay(player, npc, "Visit the corresponding ??? to accept your new weapon!")
        else
            momijiSay(player, npc, "Looks like you've already gotten your free relic, you can't have another.")
        end

        return
    end
    
    for i = xi.skill.FISHING, xi.skill.COOKING do
        if player:getCharSkillLevel(i) >= 1000 then
            npc:facePlayer(player, true)
            momijiSay(player, npc, "Congratulations Grand Master, here is your relic weapon voucher.")
            momijiSay(player, npc, "Visit the corresponding ??? to accept your new weapon!")
            player:printToPlayer(" ", xi.msg.channel.NS_SAY)
            player:setCharVar("FreeRelic", 1)
            player:setCharVar("RelicWeaponVoucher", 1)
            return
        end
    end

    momijiSay(player, npc, "It's going to take a bit more than that to impress me!")
end)

return m
