-- Override specific mission/quest functions
-----------------------------------
require("modules/module_utils")
require("scripts/globals/missions")
require('scripts/globals/utils')
require('scripts/globals/interaction/interaction_global')
-----------------------------------
local m = Module:new("cop_chapter_8_fixes")

local ringItems =
{
    xi.item.RAJAS_RING,
    xi.item.SAATVA_RING,
    xi.item.TAMAS_RING,
}

    -- (!) Temp fix
    -- Reset the player's mission status upon mission completion.
    -- Note: This is an interim solution. Seek a more robust approach.
    -- Keep an eye on upstream updates for potential changes to this workaround.
m:addOverride('xi.server.onServerStart', function()
    super()

    xi.module.modifyInteractionEntry('scripts/missions/cop/7_4_Calm_Before_the_Storm', function(mission)
        mission.sections[1][xi.zone.SEALIONS_DEN].onEventFinish =
        {
            [17] = function(player, csid, option, npc)
                mission:complete(player)
                player:setMissionStatus(6, 0)
            end
        }
    end)

    xi.module.modifyInteractionEntry('scripts/missions/cop/8_4_Dawn', function(mission)
        if mission and mission.sections and mission.sections[1] then
            if not mission.sections[1][xi.zone.UPPER_JEUNO] then
                mission.sections[1][xi.zone.UPPER_JEUNO] = {}
            end

            mission.sections[1][xi.zone.UPPER_JEUNO]._6s1 = mission.sections[1][xi.zone.UPPER_JEUNO]._6s1 or {}

            mission.sections[1][xi.zone.UPPER_JEUNO]._6s1.onTrigger = function(player, npc)
                local missionStatus = player:getCharVar('Mission[6][840]Status')
                local hasCompletedMission = player:hasCompletedMission(xi.mission.log_id.COP, xi.mission.id.cop.DAWN)
                local missionTimer = player:getCharVar('Mission[6][840]Timer')
                local rajasDropped = player:getCharVar('[RINGS]droppedRajas')
                local sattvaDropped = player:getCharVar('[RINGS]droppedSattva')
                local tamasDropped = player:getCharVar('[RINGS]droppedTamas')

            if missionTimer > 0 then
                player:printToPlayer("You are not eligible for a replacement ring yet. Please check back later.", xi.msg.channel.SYSTEM_3)
                return
            -- edge case check: If any dropped ring var is set to 1 and missionTimer is 0
            elseif (rajasDropped == 1 or sattvaDropped == 1 or tamasDropped == 1) and missionTimer == 0 then
                player:setCharVar('[RINGS]canTrade', 1)
                player:printToPlayer("You have previously dropped a reward ring. Please consult Treasurer Livia of the Ducal Guard for further instructions.", xi.msg.channel.SYSTEM_3)
                    if rajasDropped == 1 or sattvaDropped == 1 or tamasDropped == 1 then
                        player:setCharVar('[RINGS]droppedRajas', 0)
                        player:setCharVar('[RINGS]droppedSattva', 0)
                        player:setCharVar('[RINGS]droppedTamas', 0)
                        player:setCharVar('[RINGS]pendingReplacement', 1)  -- fallback tracking var
                    end
                return
            -- check mission status or completion status
            elseif missionStatus >= 6 or hasCompletedMission then
                -- check if player already has any of the rings
                for _, ringId in ipairs(ringItems) do
                    if player:hasItem(ringId) then
                        player:printToPlayer("You already possess a reward ring. Please consult Treasurer Livia of the Ducal Guard for further instructions.", xi.msg.channel.SYSTEM_3)
                        return
                    end
                end
                -- progress the mission event if the player doesn't have any rings
                local eventId = player:getCharVar('Mission[6][840]firstRing') == 1 and 84 or 204
                mission:progressEvent(eventId)
                return
            end
        end

            mission.sections[1][xi.zone.UPPER_JEUNO].onEventUpdate =
            {
                [84]  = ringOnEventUpdate,
                [204] = ringOnEventUpdate,
            }

            mission.sections[1][xi.zone.UPPER_JEUNO].onEventFinish =
            {
                [84]  = ringOnEventFinish,
                [204] = ringOnEventFinish,
            }
        end
    end)
end)
-- explicit var tracking for replacement rings if applicable.
m:addOverride("xi.items.rajas_ring.onItemDrop", function(target, item)
    xi.mission.setVar(target, xi.mission.log_id.COP, xi.mission.id.cop.DAWN, 'Timer', 1, os.time() + 27 * 24 * 60 * 60)
    target:setCharVar('[RINGS]droppedRajas', 1)
end)

m:addOverride("xi.items.sattva_ring.onItemDrop", function(target, item)
    xi.mission.setVar(target, xi.mission.log_id.COP, xi.mission.id.cop.DAWN, 'Timer', 1, os.time() + 27 * 24 * 60 * 60)
    target:setCharVar('[RINGS]droppedSattva', 1)
end)

m:addOverride("xi.items.tamas_ring.onItemDrop", function(target, item)
    xi.mission.setVar(target, xi.mission.log_id.COP, xi.mission.id.cop.DAWN, 'Timer', 1, os.time() + 27 * 24 * 60 * 60)
    target:setCharVar('[RINGS]droppedTamas', 1)
end)

return m
