------------------------------------
-- Override specific mission/quest functions
-----------------------------------
require('modules/module_utils')
-----------------------------------
local m = Module:new('cop_trusts')

m:addOverride('xi.zones.Tavnazian_Safehold.npcs._0qa.onTrigger', function(player, npc)
    if player:getCurrentMission(xi.mission.log_id.COP) == xi.mission.id.cop.CHAINS_AND_BONDS and player:getCharVar('PromathiaStatus') == 4 then
        player:startEvent(115)
    elseif player:getCurrentMission(xi.mission.log_id.COP) == xi.mission.id.cop.DAWN and player:getCharVar('PromathiaStatus') == 5 then
        player:startEvent(543)
    end

    if player:getCurrentMission(xi.mission.log_id.COP) >= xi.mission.id.cop.DAWN then
        player:addSpell(913) -- Prishe
    end
end)

m:addOverride('xi.zones.Misareaux_Coast.npcs._0p0.onTrigger', function(player, npc)
    if player:getCurrentMission(xi.mission.log_id.COP) >= xi.mission.id.cop.DAWN then
        player:addSpell(914) -- Ulmia
    end

    local ID = zones[player:getZoneID()]
    player:messageSpecial(ID.text.SNOWMINT_POINT_LOCKED)
end)

xi.module.ensureTable('xi.zones.Aht_Urhgan_Whitegate.npcs.Cushion')

m:addOverride('xi.zones.Aht_Urhgan_Whitegate.npcs.Cushion.onTrigger', function(player, npc)
    if player:getCurrentMission(xi.mission.log_id.TOAU) >= xi.mission.id.toau.PASSING_GLORY and
        not player:hasSpell(918) -- GESSHO spell
    then
        player:addSpell(918) -- GESSHO spell
        player:printToPlayer('Unlocked Trust: Gessho')
    else
        player:printToPlayer('A soft cushion.', xi.msg.channel.NS_SAY)
    end
end)

return m
