-----------------------------------
-- Area: Mine Shaft #2716
--  NPC: Armoury Crate
-----------------------------------
require('scripts/globals/battlefield')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mine_shaft_2716_armoury_crate')

xi.module.ensureTable('xi.zones.Mine_Shaft_2716.npcs.Armoury_Crate')

local loot =
{
    -- Pulling the Strings Specific Job Rewards
    [xi.job.WAR] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.JANIZARY_EARRING, droprate = 250 },
        },
    },
        
    [xi.job.MNK] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.COUNTER_EARRING, droprate = 250 },
        },
    },
    
    [xi.job.WHM] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.HEALING_FEATHER, droprate = 250 },
        },
    },
    
    [xi.job.BLM] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.SPIRIT_LANTERN, droprate = 250 },
        },
    },
    
    [xi.job.RDM] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.SANATION_RING, droprate = 250 },
        },
    },
    
    [xi.job.THF] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.ASSASSINS_RING, droprate = 250 },
        },
    },
    
    [xi.job.PLD] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.VIAL_OF_REFRESH_MUSK, droprate = 250 },
        },
    },
    
    [xi.job.DRK] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.TACTICAL_RING, droprate = 250 },
        },
    },
    
    [xi.job.BST] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.PACIFIST_RING, droprate = 250 },
        },
    },
    
    [xi.job.BRD] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.GETSUL_RING, droprate = 250 },
        },
    },
    
    [xi.job.RNG] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.DEADEYE_EARRING, droprate = 250 },
        },
    },
    
    [xi.job.SAM] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.GAMUSHARA_EARRING, droprate = 250 },
        },
    },
    
    [xi.job.NIN] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.NARUKO_EARRING, droprate = 250 },
        },
    },
    
    [xi.job.DRG] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.BAG_OF_WYVERN_FEED, droprate = 250 },
        },
    },
    
    [xi.job.SMN] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.ASTRAL_POT, droprate = 250 },
        },
    },
    
    [xi.job.BLU] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.DEATH_CHAKRAM, droprate = 250 },
        },
    },
    
    [xi.job.COR] =
    {
        {
            { itemid = 0, droprate = 750 },
            { itemid = xi.item.CORSAIR_BULLET_POUCH, droprate = 250 },
        },
    },
    
    [xi.job.PUP] =
    {
        {
            { itemid = xi.item.NONE,               droprate = 200 },
            { itemid = xi.item.ATTUNER,            droprate = 100 },
            { itemid = xi.item.TACTICAL_PROCESSOR, droprate = 100 },
            { itemid = xi.item.DRUM_MAGAZINE,      droprate = 100 },
            { itemid = xi.item.EQUALIZER,          droprate = 100 },
            { itemid = xi.item.TARGET_MAKER,       droprate = 100 },
            { itemid = xi.item.MANA_CHANNELER,     droprate = 100 },
            { itemid = xi.item.ERASER,             droprate = 100 },
            { itemid = xi.item.SMOKER_SCREEN,      droprate = 100 },
        },
    },
}

local treasure = {}

for jobID, lootInfo in pairs(loot) do
    treasure[jobID] = {}

    for _, pool in pairs(lootInfo) do
        for _, itemInfo in pairs(pool) do
            table.insert(treasure[jobID], { itemInfo.droprate, itemInfo.itemid })
        end
    end
end

cexi.util.reloadOverride(m, 'xi.zones.Mine_Shaft_2716.npcs.Armoury_Crate.onTrigger', function(player, npc)
    local battlefield = player:getBattlefield()
    local bfID        = player:getBattlefield():getID()
    local mainJob     = player:getMainJob()

    if bfID == 739 then
        local result = cexi.util.pickItem(treasure[mainJob])[2]
        if result > 0 then
            player:addTreasure(result, npc)
        end
    end
end)

return m
