-----------------------------------
-- Zilant Mobskills
-----------------------------------
require("modules/module_utils")
require("scripts/globals/mobskills")
require("scripts/globals/utils")
-----------------------------------
local m = Module:new("mobskills_zilant")

local function hasAura(mob)
    local phase = mob:getAnimationSub()
    return phase == 1 or phase == 3
end

local function hasWings(mob)
    local phase = mob:getAnimationSub()
    return phase == 1 or phase == 4
end

local function withWings(mob)
    if hasWings(mob) then
        return 0
    else
        return 1
    end
end

local function withoutWings(mob)
    if hasWings(mob) then
        return 1
    else
        return 0
    end
end

local function withAura(mob)
    if hasAura(mob) then
        return 0
    else
        return 1
    end
end

local skills =
{
    -----------------------------------
    -- Regular skills
    -----------------------------------
    ["abyssic_buster"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            return withoutWings(mob)
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CHOKE, 15, 3, 60)

            local dmgmod = 3.5
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
            return dmg
        end,
    },

    ["dancing_tail"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            if target:isBehind(mob, 96) then
                return 0
            end

            return 1
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.POISON, 50, 3, 120)

            local dmgmod = 4.0
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
            return dmg
        end,
    },

    ["chilling_roar"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            return withoutWings(mob)
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.TERROR, 0, 0, 15)

            local dmgmod = 1.0
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.ICE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.ICE)
            return dmg
        end,
    },

    -----------------------------------
    -- Wings only
    -----------------------------------
    ["dexter_wing"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            return withWings(mob)
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.ATTACK_DOWN,    30, 0, 60)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAGIC_ATK_DOWN, 30, 0, 60)

            local dmgmod = 3.0
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
            return dmg
        end,
    },

    ["sinister_wing"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            return withWings(mob)
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.ACCURACY_DOWN,  30, 0, 60)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAGIC_ACC_DOWN, 30, 0, 60)

            local dmgmod = 3.0
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
            return dmg
        end,
    },

    ["chaos_blast"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            return withWings(mob)
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAX_HP_DOWN, 30, 0, 60)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.MAX_MP_DOWN, 30, 0, 60)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BIO,         30, 3, 60)

            local dmgmod = 2.5
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
            return dmg
        end,
    },

    -----------------------------------
    -- Aura only
    -----------------------------------
    ["soul_douse"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            return withAura(mob)
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.DOOM, 10, 3, 45)

            local dmgmod = 1
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
            return dmg
        end,
    },

    ["dark_star"] =
    {
        onMobSkillCheck  = function(target, mob, skill)
            return withAura(mob)
        end,

        onMobWeaponSkill = function(target, mob, skill)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.CHOKE,     30, 3, 60)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BLINDNESS, 20, 0, 60)
            xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.STUN,       1, 0,  5)

            local dmgmod = 4.0
            local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg() * 3, xi.element.DARK, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
            local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

            target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.DARK)
            return dmg
        end,
    },
}

for skillName, skillInfo in pairs(skills) do
    local skillPath = string.format("xi.actions.mobskills.%s", skillName)
    xi.module.ensureTable(skillPath)

    m:addOverride(skillPath .. ".onMobWeaponSkill", skillInfo.onMobWeaponSkill)
    m:addOverride(skillPath .. ".onMobSkillCheck", skillInfo.onMobSkillCheck)
end

return m
