-----------------------------------
--  Meteor
--
--  Description: Hardcore non-elemental damage
--  Type: Magical
--  Explanation: This override is required in order to get KS99 Horns of War working.
--  The code for Chlevnik was borrowed from AirSkyBoat, and would error out without this.
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
local m = Module:new("wild_rage")

xi.module.ensureTable("xi.actions.mobskills.meteor")

m:addOverride("xi.actions.mobskills.wild_rage.onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod  = 1
    local dmgmod  = 2.1
    local info    = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)

    -- Platoon Scorpion special behavior.
    if mob:getPool() == 3157 then
        local ragePower = mob:getLocalVar("wildRagePower")

        info.dmg = info.dmg * (1 + 0.3 * ragePower)
    end

    -- King Vinegrroon special behavior.
    if mob:getPool() == 2262 then
        local typeEffect = xi.effect.POISON
        local power      = 25
 
        xi.mobskills.mobPhysicalStatusEffectMove(mob, target, skill, typeEffect, power, 3, 60)
    end

    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)

    return dmg
end)

return m
