-----------------------------------
-- Velkkan Pygmachia
-- Damage (4 hits)
-- Additional Effect (Each hit): Dispel
-----------------------------------
require('scripts/globals/mobskills')
require('modules/module_utils')
-----------------------------------
local m = Module:new('mobskill_velkkan_pygmachia')
local path = "xi.actions.mobskills.velkkan_pygmachia"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local numhits = 4
    local accmod = 1
    local dmgmod = 1
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.physicalTpBonus.DMG_VARIES, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.BLUNT, xi.mobskills.shadowBehavior.NUMSHADOWS_3)
    local dispel1 = target:dispelStatusEffect()
    local dispel2 = target:dispelStatusEffect()
    local dispel3 = target:dispelStatusEffect()
    local dispel4 = target:dispelStatusEffect()
    local total = 0

    if dispel1 ~= xi.effect.NONE then
        total = total + 1
    end

    if dispel2 ~= xi.effect.NONE then
        total = total + 1
    end

    if dispel3 ~= xi.effect.NONE then
        total = total + 1
    end

    if dispel4 ~= xi.effect.NONE then
        total = total + 1
    end

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.BLUNT)

    if total == 0 then
        return dmg
    else
        skill:setMsg(xi.msg.basic.DISAPPEAR_NUM)

        return total
    end
end)

return m
