-----------------------------------
-- Trinary Absorption
-- Attempts to absorb one buff from a single target, or otherwise steals HP.
-- Type: Magical
-- Utsusemi/Blink absorb: 1 Shadows
-- Range: Melee
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
local m = Module:new("trinary_absorption")

xi.module.ensureTable("xi.actions.mobskills.trinary_absorption")

m:addOverride("xi.actions.mobskills.trinary_absorption.onMobSkillCheck", function(target, mob, skill)
    if
        mob:isMobType(xi.mobType.NOTORIOUS) or
        target:hasStatusEffect(xi.effect.BATTLEFIELD)
    then
        return 0
    end

    return 1
end)

m:addOverride("xi.actions.mobskills.trinary_absorption.onMobWeaponSkill", function(target, mob, skill)
    local power = math.random(50, 150)
    local dmg = xi.mobskills.mobFinalAdjustments(power, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.DARK, xi.mobskills.shadowBehavior.NUMSHADOWS_1)

    skill:setMsg(xi.mobskills.mobPhysicalDrainMove(mob, target, skill, xi.mobskills.drainType.HP, dmg))

    return dmg
end)

return m
