---------------------------------------------
--  Summon Wyrm
--  Family: Bahamut
--  Description: Summons a random CoP Wyrm to fight with Bahamut.
--  Type: Summoning
--  Notes: Used by Bahamut at 80%, 60%, 40%, 20% of its HP.
---------------------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------
xi.module.ensureTable("xi.actions.mobskills.touchdown_bahamut")
local m = Module:new("mobskill_touchdown_bahamut")

m:addOverride("xi.actions.mobskills.touchdown_bahamut.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.touchdown_bahamut.onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1
    local ftp100 = 1.5
    local ftp200 = 1.75
    local ftp300 = 2.0
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT, ftp100, ftp200, ftp300)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

    if not skill:hasMissMsg() then
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    end

    return dmg
end)

return m
