-----------------------------------
--  Touchdown
--
--  Description: Deals magical damage to enemies in an area of effect upon landing.
--  Further Notes:
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------

local m = Module:new("touchdown")

xi.module.ensureTable("xi.actions.mobskills.touchdown")

m:addOverride("xi.actions.mobskills.touchdown.onMobSkillCheck", function(target, mob, skill)
    if mob:getAnimationSub() ~= 1 then
        return 1
    end

    return 0
end)

m:addOverride("xi.actions.mobskills.touchdown.onMobWeaponSkill", function(target, mob, skill)
    local dmgmod = 1
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getWeaponDmg()*4, xi.element.NONE, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.NONE, xi.mobskills.shadowBehavior.WIPE_SHADOWS)
    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.NONE)
    mob:delStatusEffect(xi.effect.ALL_MISS)
    mob:setMobSkillAttack(0)
    mob:setAnimationSub(2)
    return dmg
end)

return m
