-----------------------------------
-- The Wrath of Gudha
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
local m = Module:new("the_wrath_of_gudha")

m:addOverride("xi.actions.mobskills.the_wrath_of_gudha.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.the_wrath_of_gudha.onMobWeaponSkill", function(target, mob, skill)
    local typeEffect = xi.effect.WEIGHT

    local numhits = 1
    local accmod = 1
    local dmgmod = 1
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, 0, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.NONE, info.hitslanded)

        xi.mobskills.mobStatusEffectMove(mob, target, typeEffect, 40, 0, 10)

    target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.NONE)
    return dmg
end)

return m
