-----------------------------------
--  Tempest Wing
--  Family: Bahamut
--  Description: Turbulence deals Wind damage to enemies within a very wide area of effect. Additional effect: Knockback
--  Type: Magical
--  Utsusemi/Blink absorb: Wipes shadows
--  Range: Cone
--  Notes:
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
xi.module.ensureTable("xi.actions.mobskills.tempest_wing")
local m = Module:new("mobskill_tempest_wing")

m:addOverride("xi.actions.mobskills.tempest_wing.onMobSkillCheck", function(target, mob, skill)
    if target:isBehind(mob, 55) then
        return 1
    else
        return 0
    end
end)

m:addOverride("xi.actions.mobskills.tempest_wing.onMobWeaponSkill", function(target, mob, skill)
    local dmgmod = 1
    local info = xi.mobskills.mobMagicalMove(mob, target, skill, mob:getMainLvl() * 4.75, xi.element.WIND, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
    local dmg = xi.mobskills.mobFinalAdjustments(info, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.WIND, xi.mobskills.shadowBehavior.IGNORE_SHADOWS)
    target:takeDamage(dmg, mob, xi.attackType.MAGICAL, xi.damageType.WIND)
    xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.BLINDNESS, 50, 0, 60)
    return dmg
end)

return m
