---------------------------------------------
--  Tegmina Buffet
--  Family: Chapuli
--  Type: Physical, Enfeebling
--  Can be erased: Check
--  Utsusemi/Blink absorb: Takes 1-3 Shadows
--  Range: Melee
---------------------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------

local m = Module:new("mobskill_tegmina_buffet")
local path = "xi.actions.mobskills.tegmina_buffet"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local numhits = 3
    local accmod = 8
    local dmgmod = utils.clamp(math.floor(target:getMainLvl() / 10), 1, 5) -- This probably still too high, most mobskills are 1~3
    local power = 20
    local duration = 120
    local attackType = xi.attackType.PHYSICAL
    local damageType = xi.damageType.SLASHING
    local tpBonus = xi.mobskills.physicalTpBonus.DMG_VARIES
    local effectType = xi.effect.CHOKE
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, tpBonus, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, attackType, damageType, info.hitslanded)

    -- Reduce damage to higher levels
    local targLevel = target:getMainLvl()
        
    if targLevel > 82 then
        if targLevel > 102 then
            targLevel = 102
        end
        dmg = math.floor(dmg * (1 - ((targLevel - 82) / 40))) -- Gradually reduces to -2.5% damage per level (caps at 50% dmg by lvl 102)
    end

    target:takeDamage(dmg, mob, attackType, damageType)
    xi.mobskills.mobStatusEffectMove(mob, target, effectType, power, 0, duration)
    return dmg
end)

return m
