-----------------------------------
--  Sweeping Flail
--  Family: Bahamut
--  Description: Spins around to deal physical damage to enemies around user. Additional effect: Knockback
--  Type: Physical
--  Utsusemi/Blink absorb: 2-3 shadows
--  Range: 20' radial
--  Notes: Used when someone pulls hate from behind Bahamut.
-----------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
-----------------------------------
xi.module.ensureTable("xi.actions.mobskills.sweeping_flair")
local m = Module:new("mobskill_sweeping_flair")

m:addOverride("xi.actions.mobskills.sweeping_flair.onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride("xi.actions.mobskills.sweeping_flair.onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 1
    local dmgmod = 1
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, xi.mobskills.magicalTpBonus.NO_EFFECT)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, xi.attackType.PHYSICAL, xi.damageType.SLASHING, info.hitslanded * math.random(2, 3))

    if not skill:hasMissMsg() then
        target:takeDamage(dmg, mob, xi.attackType.PHYSICAL, xi.damageType.SLASHING)
    end

    return dmg
end)

return m
