---------------------------------------------
--  Summon Wyrm
--  Family: Bahamut
--  Description: Summons a random CoP Wyrm to fight with Bahamut.
--  Type: Summoning
--  Notes: Used by Bahamut at 80%, 60%, 40%, 20% of its HP.
---------------------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------
local ID = require("scripts/zones/Riverne-Site_B01/IDs")
local m = Module:new("mobskill_summon_wyrm")

xi.module.ensureTable("xi.actions.mobskills.summon_wyrm")

m:addOverride("xi.actions.mobskills.summon_wyrm.onMobSkillCheck", function(target, mob, skill)
    return 1
end)

m:addOverride("xi.actions.mobskills.summon_wyrm.onMobWeaponSkill", function(target, mob, skill)
    local randWyrm = mob:getLocalVar("randWyrm")
    local pet = GetMobByID(ID.mob.BAHAMUT_V2 + randWyrm)

    pet:spawn()
    pet:updateEnmity(target)
    skill:setMsg(xi.msg.basic.NONE)
    mob:setLocalVar("summoning", 0)

    return 0
end)

return m
