---------------------------------------------
--  Spectral Floe
--  Family: Elemental
--  Type: Magical (AoE)
---------------------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------

local m = Module:new("mobskill_spectral_floe")
local path = "xi.actions.mobskills.spectral_floe"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local damage = mob:getWeaponDmg() * 5

    damage = xi.mobskills.mobMagicalMove(mob, target, skill, damage, xi.element.ICE, 1, xi.mobskills.magicalTpBonus.MAB_BONUS, 1)
    damage = xi.mobskills.mobFinalAdjustments(damage, mob, skill, target, xi.attackType.MAGICAL, xi.damageType.ICE, xi.mobskills.shadowBehavior.WIPE_SHADOWS)

    target:takeDamage(damage, mob, xi.attackType.MAGICAL, xi.damageType.ICE, { breakBind = false })
    xi.mobskills.mobStatusEffectMove(mob, target, xi.effect.TERROR, 1, 0, 30)

    return damage
end)

return m
