---------------------------------------------
--  Sensilla Blades
--  Family: Chapuli
--  Type: Physical, Slashing (AoE Conal)
--  Range: Melee
---------------------------------------------
require("scripts/globals/mobskills")
require("modules/module_utils")
---------------------------------------------

local m = Module:new("mobskill_sensilla_blades")
local path = "xi.actions.mobskills.sensilla_blades"

xi.module.ensureTable(path)

m:addOverride(path .. ".onMobSkillCheck", function(target, mob, skill)
    return 0
end)

m:addOverride(path .. ".onMobWeaponSkill", function(target, mob, skill)
    local numhits = 1
    local accmod = 6
    local dmgmod = utils.clamp(math.floor(target:getMainLvl() / 5), 1, 10)
    local attackType = xi.attackType.PHYSICAL
    local damageType = xi.damageType.SLASHING
    local tpBonus = xi.mobskills.physicalTpBonus.DMG_VARIES
    local info = xi.mobskills.mobPhysicalMove(mob, target, skill, numhits, accmod, dmgmod, tpBonus, 1, 2, 3)
    local dmg = xi.mobskills.mobFinalAdjustments(info.dmg, mob, skill, target, attackType, damageType, info.hitslanded)

    -- Adjust for conal
    local isInCone = 0
    if target:isInfront(mob, 32) then
        isInCone = 1
    end

    dmg = dmg * isInCone

    target:takeDamage(dmg, mob, attackType, damageType)
    return dmg
end)

return m
